# #
# $Date: 1995/03/01 15:32:41 $  $Author: frankp $   $Revision: 1.11 $ #
# #
# frankp, 17/08/94 #

#++
  stack.mu

	linalg::stackMatrix  --  inserts matrices vertically 

	stackMatrix(A,B,C,..)

	Appends matrices B,C,.. to A vertically. The matrices
        B,C,... are converted to matrices of type of A.
        If A is of type SquareMatrix then A is converted to Matrix.

++#

linalg::stackMatrix := proc(A)
    name linalg::stackMatrix;
    local i, c, B, t;
begin
    if testargs() then
        if args(0) < 2 then error("wrong no of args") end_if;
        if A::hasProp( MatrixCat ) <> TRUE then
            error("expecting matrices")
        end_if;
       if A::constructor = SquareMatrix then
            B := A::getSuperDomain(A)
        else
            B := type(A)
        end_if;
        c := op(A::dimen(A),2);
        for i from 2 to args(0) do
            if not testtype( args(i),B ) then
                error("types of matrices don't match")
            end_if;
            if op((args(i))::dimen(args(i)),2) <> c then
                error("matrices are not compatibel")
            end_if
        end_for
    end_if;

    if A::constructor = SquareMatrix then
        A := A::convert_to( A,A::getSuperDomain(A) )
    end_if;

    c := A::stackMatrix;
    t := A::convert;
    for i from 2 to args(0) do
        B := t( args(i) );
        if B = FAIL then B := (args(i))::convert_to( args(i),type(A) ) end_if;
        A := c( A,B )
    end_for;
    A
end_proc:

# end of file #
