# #
# $Date: 1995/07/17 07:26:56 $  $Author: frankp $   $Revision: 1.13.2.1 $ #
# #
# frankp, 21/06/94 #

#++
  setrow.mu

	linalg::setRow(A,p,r)   --  sets row p of A to row r
 
	A: matrix
	r: expression  
	p: positive integer
++#

linalg::setRow := proc(A,p,r)
    name linalg::setRow;
    local t,T;
begin
    if testargs() then
	if args(0) <> 3 then error("wrong no of args") end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a matrix")
	end_if;
	if not testtype( p,Type::PosInt ) then
	    error("index must be a positive integer")
	end_if;
	if p > op( A::dimen(A),1 ) then
	    error("index out of range")
	end_if;
	if A::constructor = SquareMatrix then
            T := Matrix(A::coeffRing)
        else
            T := domtype(A)
        end_if;
	if domtype(r) = DOM_LIST then
	    r := T::convert( [r] );
	    if r = FAIL then
		error("3rd argument is not a valid row")
	    end_if
	elif T <> domtype(r) then
	    t := T::convert(r);
            if t <> FAIL then r := t
            else
                r := r::convert_to( r,T );
                if r = FAIL then
                    error("3rd argument is not a valid row")
                end_if
            end_if
        end_if;
        t := r::dimen(r);
        if op(t,1) <> 1 or op(t,2) > op(A::dimen(A),2) then
            error("wrong size of row vector")
        end_if
    end_if;

    if A::constructor = SquareMatrix then
        T := Matrix(A::coeffRing)
    else
        T := domtype(A)
    end_if;
    if domtype(r) = DOM_LIST then
	r := T::convert( [r] )
    elif domtype(r) <> T then
	t := T::convert(r);
	if t <> FAIL then r := t else r := r::convert_to(r,T) end_if
    end_if;

    A::setRow( A,p,r )
end_proc:

# end of file #
