# #
# $Date: 1995/05/31 20:22:45 $  $Author: frankp $   $Revision: 1.5 $ #
# #
# frankp, 06/02/95 #

#++
  randmat.mu

	linalg::randomMatrix -- generates a random matrix

	randomMatrix( m, n [,R, Struct] )

	m, n  : positive integers
	R     : (optional) coefficient domain (of category Rng)

	randomMatrix generates a random matrix A of dimension m by n.

	If a coefficient Ring R is not given then the random matrix
	will be of type Matrix(ExpressionField). Otherwise R has
	to provide the method "random".
++#

linalg::randomMatrix := proc(m, n) 
    name linalg::randomMatrix;
    local R, Rrandom, i, j;
begin
    if testargs() then
	if args(0) < 2 or args(0) > 3 then
	    error("wrong no of args")
	end_if;
	if not testtype(m,Type::PosInt) or not testtype(n,Type::PosInt) then
	    error("expecting dimension as positive integers")
	end_if;
	if args(0) = 3 then
	    R := args(3);
	    if R::hasProp( Rng ) <> TRUE then
		error("coefficient ring must be a Rng")
	    end_if
	end_if
    end_if;

    if args(0) = 2 then R := ExpressionField() else R := args(3) end_if;

    Rrandom := R::random;
    if Rrandom = FAIL then
	error("Domain attribute \"random\" missing")
    end_if;
    R := domattr(Matrix(R),"newThis")(m,n,[[Rrandom() $ j=1..n] $ i=1..m])
end_proc:

# end of file #
