# #
# $Date: 1995/01/14 18:26:57 $  $Author: frankp $   $Revision: 1.13 $ #
# #
# frankp, 04/09/94 #

#++
    onset.mu

    linalg::onSystem  --  returns an orthonormal system of vectors

	onSystem( S )

	S : list or set of vectors

	Computes an orthonormal system of linearly independent vectors 
	in S by using the function linalg::onSystem and normalizing
	all vectors to length 1.

	Are the vectors linearly dependend the computed set will be
	linearly dependend too.

	An error occurs if a vector can not be normalized over it's 
	coefficient domain.
++#

linalg::onSystem := proc(S)
    name linalg::onSystem;
    local s, t, R;
begin
    if testargs() then
        if args(0) <> 1 then error("wrong no of args") end_if;
        t := Type::ListOf;
        case domtype(S)
        of DOM_SET  do  t := Type::SetOf
        of DOM_LIST do  if nops(S) = 0 then break end_if;
                        s := op(S,1);
                        if not testtype( s,linalg::VectorOf(Type::AnyType) ) then
                            error("expecting list or set of vectors")
                        end_if;
                        R := s::coeffRing;
                        if not R::hasProp( Field ) then
                            error("expecting vectors over a field")
                        end_if;
                        s := max( op(s::dimen(s)) );
                        if not testtype( S,t(linalg::VectorOf(R,s)) ) then
                            error("vectors are not compatible")
                        end_if;
                        break
        otherwise       error("expecting list or set of vectors")
        end_case
    end_if;

    if nops(S) = 0  then return( S ) end_if;
    t := linalg::ogSystem( S );
    map( t,linalg::normalize )
end_proc:

# end of file #
