# #
# $Date: 1995/05/26 14:13:35 $  $Author: frankp $   $Revision: 1.10 $ #
# #
# frankp, 28/10/94 #

#++
  normaliz.mu

	linalg::normalize -- normalizes vectors over fields
			     using the 2-norm


	normalize(v)

	v: vector

	This function normalizes v.
	An error occurs if v::norm(v,2) returns FAIL.
++#

linalg::normalize := fun(
    (if testargs() then
	if args(0) <> 1 then error("wrong no of args") end_if;
	if not testtype( args(1),linalg::VectorOf(Type::AnyType) ) then
	    error("expecting a vector")
	end_if;
	if not ((args(1))::coeffRing)::hasProp( Field ) then
	    error("expecting vector over a field")
	end_if
    end_if;

    (args(1))::norm(args(1),2);
    if % = FAIL then
 	error("unable to normalize the vector over ".
	    expr2text((args(1))::coeffRing)
	)	
    else
	(args(1))::_mult(args(1),1/%)
    end_if)
):

# end of file #
