# #
# $Date: 1995/05/26 14:13:34 $  $Author: frankp $   $Revision: 1.13 $ #
# #
# frankp, 16/08/94 #

#++
  mulrow.mu

	linalg::multRow -- multiply rows of a matrix by an expression

	multRow(A,{p,i..j,l},s)

	A   : matrix, square matrix
	p   : positive integers
	i..j: range of positive integers
	l   : list of positive integers

	After s is converted into an element of A::coeffRing, 'multRow'
	returns a copy of matrix A in which row p is multiplied right by 's',
	or in which the rows i to j are multiplied right by 's' when the
	second argument is a range of positive integers i and j. If a list
	l is given then the rows are multiplied by s which are specified in l.
++#

linalg::multRow := proc(A,p,s)
    name linalg::multRow;
    local i, c, R;
begin
    if testargs() then
	if args(0) <> 3 then error("wrong no of args") end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error ("expecting a matrix")
	end_if;
        i := op( A::dimen(A),1 );
        if testtype( p,Type::PosInt ) then
            if p > i then error("index out of range") end_if
        elif type(p) = "_range" then
            if not testtype( op(p,1),Type::PosInt )
               or not testtype( op(p,2),Type::PosInt )
            then
                error("expecting range of positive integers")
            end_if;
            if op(p,1) > i or op(p,2) > i then
                error("range larger than upper matrix bound")
            end_if
	elif testtype(p,Type::ListOf(Type::PosInt,1)) then
            if max(op(p)) > i then
                error("indices in list larger than upper matrix bound")
            end_if
        else
            error("invalid 2nd argument")
        end_if;
	if not testtype( s,A::coeffRing ) then
	    error("unable to convert ".expr2text(s))
	end_if
    end_if;

    R := A::coeffRing;
    if domtype(s) <> R then
	c := R::convert( s );
	if c = FAIL then s := s::convert_to( s,R ) else s := c end_if
    end_if;

    c := op( A::dimen(A),2 );
    if type(p) = "_range" then
	for i from min(op(p)) to max(op(p)) do
            ( A[i,j] := R::_mult(A[i,j],s) ) $ hold(j)=1..c
	end_for
    elif domtype(p) = DOM_LIST then
        for i in p do
            ( A[i,j] := R::_mult(A[i,j],s) ) $ hold(j)=1..c
        end_for
    else
	( A[p,j] := R::_mult(A[p,j],s) ) $ hold(j)=1..c
    end_if;
    A
end_proc:

# end of file #
