# #
# $Date: 1995/07/12 16:00:22 $  $Author: frankp $   $Revision: 1.5.2.2 $ #
# #
# frankp, 18/05/95 #

#++
  jordan.mu

        linalg::jordanForm -- compute the Jordan form of a matrix

	jordanForm(A [,All])

	A  : square matrix
	All: (optional) ident

	jordanForm(A) computes and returns the Jordan form J of A.
	If the option 'All' is given then the list [J,P] will be 
	returned where P is the transformation matrix corresponding
	to the Jordan matrix.

	When all the eigenvalues of A can't be computed then FAIL
	will be returned.
++#

linalg::jordanForm := proc(A)
    local i, j, l, ev, P, iP, r, nS, linsolve, mA, n;
begin
    if testargs() then
	if args(0) < 1 or args(0) > 2 then
	    error("wrong no of args")
	end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a matrix")
	end_if;
	n := A::dimen(A);
	if op(n,1) <> op(n,2) then
	    error("expecting a square matrix")
	end_if;
	if args(0) = 2 then
	    if args(2) <> hold(All) then
		error("option 'All' expected")
	    end_if
	end_if
    end_if;

    n := op(A::dimen(A),1);
    userinfo(1,"compute eigenvalues and eigenvectors");
    ev := linalg::eigenVectors(A);
    if ev = FAIL then return( FAIL ) end_if;

    linsolve := linalg::linearSolve;
    mA := A::negate(A);

    userinfo(1,"compute Jordan transformation matrix P");
    P := 0;
    for i from 1 to nops(ev) do
	nS := op(ev,[i,3]); # list of EV's #
	r := nops(nS);
	l := 1;
	if r < op(ev,[i,2]) then
	    iP := A::_plus( A::newThis(n,n,op(ev,[i,1]),Diagonal),mA );
	    while r < op(ev,[i,2]) do 
	        userinfo(2,"solve the jordan chain for ",op(ev,[i,1]));
	        nS := append(nS,linsolve(iP,nS[l],hold(Special)));
	        r := r + 1;
	        l := l + 1
	    end_while
	end_if;

	if P = 0 then
	    P := nS[1];
	    (P := P::concatMatrix( P,nS[j] )) $ j=2..r
	else
	    (P := P::concatMatrix( P,nS[j] )) $ j=1..r
	end_if
    end_for;
    if A::constructor = SquareMatrix then P := A::convert(P) end_if;
    iP := P::invert(P);

    if args(0) = 2 then [A::_mult(iP,A,P),iP]
    else A::_mult(iP,A,P)
    end_if
end_proc: 

# end of file #

