# #
# $Date: 1995/06/16 13:39:58 $  $Author: frankp $   $Revision: 1.1.2.1 $ #
# #
# frankp, 30/03/95 #

#++
  jacobian.mu

        linalg::jacobian -- computes the Jacobian matrix of a vector function

        jacobian(f, v)

        f : list or vector of expressions (the vector function)
        v : list or vector of variables

	jacobian(f,v) computes the Jacobian matrix of f with respect to v.
	Th (i,j)-th entry of matrix is defined to be diff(f[i],v[j]).

	'v' must be a list if 'f' is it, and then the jacobian matrix will
	be defined ober ExpressionField().
	If 'f' is a vector over a coefficient domain R then 'v' must be a 
	vector over R too. In this case the coefficient domain of 'f' has 
	to provide the method "diff".
++#

linalg::jacobian := proc(f,v)
    name linalg::jacobian;
    local i, j, Rdiff, nv, nf;
begin
    if testargs() then
	if args(0) <> 2 then error("wrong no of args") end_if;
	if testtype( f,linalg::VectorOf(Type::AnyType) ) then
	    if not (f::coeffRing)::hasProp( Field ) then
                error("expecting vector function over a field")
            end_if;
	    if not testtype( v,linalg::VectorOf(f::coeffRing) )
	    then
		error("expecting two vectors of same type")
	    end_if
	elif domtype(f) = DOM_LIST then
	    if not testtype( args(2),Type::ListOfIdents() ) then
		error("expecting a list of variables")
	    end_if
	else
	    error("expecting vector function in form of a list or vector")
	end_if
    end_if;

    if domtype(f) = DOM_LIST then
	loadlib("domains");  # force loading #
	return( Matrix()([[diff(f[i],v[j]) $ j=1..nops(v)] $ i=1..nops(f)]) )
    end_if;

    Rdiff := (f::coeffRing)::diff;
    if Rdiff = FAIL then
	error("Domain attribute \"diff\" missing")
    end_if;
    
    nv := max(op(v::dimen(v)));
    nf := max(op(f::dimen(f)));
    f::newThis( nf,nv,[[Rdiff(f[i],v[j]) $ j=1..nv] $ i=1..nf] )
end_proc:

# end of file #
