# #
# $Date: 1995/05/26 14:13:28 $  $Author: frankp $   $Revision: 1.2 $ #
# #
# frankp, 16/05/95 #

#++
  isposdef.mu

        linalg::isPosDef -- test if a matrix is positive definite

	isPosDef( A )

	A: matrix over a field

	isPosDef(A) tests if A is positive definite and returns TRUE
	and FALSE respectivly.
	
	A is positiv definit if A is Hermitian and also satisfies

	     T
	    x  A x > 0

	for all positive vectors x of type of A.
		
	If the coefficient ring of A does not provide the method
	"conjugate" then same definition holds with A has to
	be symmetric.

	The test is done by the function call linalg::cholesky(A,isPosDef)
	if A is Hermitian (or symmetric).
++#

linalg::isPosDef := proc(A)
    name linalg::isPosDef;
    local R;
begin
    if testargs() then
	if args(0) <> 1 then error("wrong no of args") end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a matrix")
	end_if;
	R := A::coeffRing;
	if not R::hasProp( Field ) then
	    error("expecting matrix over a field")
	end_if
    end_if;

    R := A::coeffRing;
    if R::conjugate = FAIL then
	if not bool( A = A::transpose(A) ) then return( FALSE ) end_if
    elif not bool( A = A::transpose(A::conjugate(A)) ) then
	return( FALSE )
    end_if;

    linalg::cholesky( A,hold(isPosDef) )
end_proc:

# end of file #
