# #
# $Date: 1995/06/16 13:39:56 $  $Author: frankp $   $Revision: 1.14.2.1 $ #
# #
# frankp, 04/09/94 #

#++
  freeset.mu

    linalg::freeSet  --  returns a set of linear independent vectors
			 over a field

	freeSet(S)

	S : list or set of vectors

	Removes such vectors in S which are linearly dependent of all
	the other vectors in S.

	The computed set is a basis for the vectorspace spanned by 
	the vectors in S.
++#

linalg::freeSet := proc(S)
    name linalg::freeSet;
    local i, j, p, k, kk, n, t, R, FS, rS, c, Miszero, Riszero, u, v;
begin
    if testargs() then
	if args(0) <> 1 then error("wrong no of args") end_if;
	t := Type::ListOf;
	case domtype(S)
	of DOM_SET  do
	    t := Type::SetOf
	of DOM_LIST do
	    if nops(S) = 0 then break end_if;	
	    R := op(S,1);
	    if not testtype(R,linalg::VectorOf(Type::AnyType)) then
		error("expecting set or list of vectors")
	    end_if;
	    n := max( op(R::dimen(R)) ); R := R::coeffRing;
	    if not R::hasProp( Field ) then
		error("expecting vectors over a field")
	    end_if;
   	    if not testtype( S,t(linalg::VectorOf(R,n)) ) then
		error("vectors are not compatibel")
	    end_if;
	    break
	otherwise
	    error("expecting a list or set of vectors")
	end_case
    end_if;

    rS := [ op(S) ];
    if nops(rS) = 0 then return( S ) end_if;
    t := rS[1];
    R := t::coeffRing;
    Miszero := t::iszero;
    Riszero := R::iszero; 

    n := max( op(t::dimen(t)) );
    FS := [];
    t := [ NIL $ n ]; 
    p := 1;
    for i from 1 to nops(rS) do
	if Miszero( rS[i] ) then next end_if;
 	t[p] := rS[i];
	kk := 1;
	u := t[p];
	# test whether u is linearly dependent of one of the other vectors #
	for j from 1 to p-1 do
	    v := t[j];
	    for k from kk to n do
		if Riszero(u[k]) and not Riszero(v[k]) then
		    break  # u and v are linearly independent #
		end_if;
		if Riszero(u[k]) then
		    next # k #
		end_if;
		kk := k;
		if Riszero(v[k]) then
		    t[j] := u; u := v; t[p] := v;
		    break # next j #
		end_if;
		c := R::negate( R::divex(u[k],v[k]) );
		u[k] := R::zero;
		(u[l] := R::_plus(u[l],R::_mult(v[l],c))) $ hold(l)=k+1..n;
		t[p] := u;
		break # next j #
	    end_for
	end_for;

	if not Miszero(u) then
	    FS := append( FS,rS[i] );
	    if nops(FS) = n then break end_if;
	    p := p + 1
	end_if
    end_for;

    if domtype(S) = DOM_LIST then FS else {op(FS)} end_if
end_proc:

# end of file #
