# #
# $Date: 1995/07/17 07:04:23 $  $Author: frankp $   $Revision: 1.15.2.1 $ #
# #
# frankp, 04/09/94 #

#++
  factorqr.mu

    linalg::factorQR  --  returns the QR-factorization of a regular
			  square matrix. 

	factorQR( A )

	A : regulaer square matrix 

	Returns a list of two matrices Q and R such that
	A = Q * R, where Q is an orthogonal matrix and R is an upper
	triangular matrix.
	The matrix A has to be defined over a field.

	The algorithm (similar to the orthogonalization process of
	Gram-Schmidt) uses the function linalg::scalarProduct.
	The 2-norm is used to normalize vectors.
	An error occurs if the 2-norm can not be computed over the field.
++#

linalg::factorQR := proc(A)
    name linalg::factorQR;
    local T, n, i, j, Q, R, bi, bj, aj, s, scalarProduct,
	  Tdivex, Tmult, QList, Tiszero;
begin
    if testargs() then
	if args(0) <> 1 then error("wrong no of args") end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a square matrix")
	end_if;
	if not (A::coeffRing)::hasProp( Field ) then
	    error("expecting matrix over a field")
	end_if;
	s := A::dimen(A);
	if op(s,1) <> op(s,2) then
	    error("expecting a square matrix")
	end_if
    end_if;

    T := A::coeffRing;
    n := op( A::dimen(A),1 );

    scalarProduct := linalg::scalarProduct;
    Tdivex := T::divex; 
    Tmult := T::_mult; 
    Tiszero := T::iszero; 

    s := T::zero;
    R := array(1..n,1..n,[ [s $ i-1, T::one, s $ n-i] $ i=1..n]);
    QList := [ A::col(A,1), NIL $ n-1 ];
    for j from 2 to n do
	aj := A::col(A,j);
	bj := aj;
	for i from 1 to j-1 do
	    bi := QList[i];
	    s := scalarProduct(bi,bi);
	    if Tiszero( s ) then
		error("given matrix is singular or invalid scalar product")
	    end_if;
	    s := Tdivex( scalarProduct(bi,aj),s );
	    R[i,j] := s;
	    if not Tiszero(s) then
		bj := _plus( bj,_mult(bi,T::negate(s)) )
	    end_if
	end_for;
	if not iszero( bj ) then
	    QList[j] := bj
	else
	    error("given matrix is singulaer or invalid scalar product")
	end_if
    end_for;

    # normalize columns of Q and compute R #
    Q := A::newThis(n,n);
    j := NIL;
    for i from 1 to n do
	bi := QList[i];
	s := bi::norm( bi,2 );
	if s = FAIL then
            error("unable to normalize vectors over ".expr2text(T))
	end_if;
	Q := Q::setCol( Q,i,bi::_mult(bi,Tdivex(1,s)) );
	(R[i,j] := Tmult( s,R[i,j] )) $ j=1..n
    end_for;

    [Q,A::newThis(R)]
end_proc:

# end of file #
