# #
# $Date: 1995/06/16 13:39:55 $  $Author: frankp $   $Revision: 1.21.2.1 $ #
# #
# frankp, 1/08/94 #

#++
  expr2mat.mu

    linalg::expr2Matrix  --  builds up a matrix from a set or list of 
			     equations

	expr2Matrix(eqns [,vars] [,coeffRing] [,Include])

	eqns, vars - sets or lists
	Include    - ident

	Generates the coefficient matrix from the linear system of 
	equations eqns in the unkown vars. If vars is not given,
	'indets(eqns,PolyExpr)' is used to get the unknown vars of the
	equations. The coefficient matrix and a vector which represents
	the right sides of the equations are returned as a list.

	If an argument 'Include' is present, the negative of the
	right side of the equations will be included as the last column
	of the matrix, which is returned.

	If coeffRing is missing then the default coeffcient domain for 
	matrices will be used (i.e. 'ExpressionField()').
	If coeffRing is given then it must be of category CommutativeRing.

	This function can be used for building up the coefficient matrix of
	expressions instead of equations in the same way. In this case
	expressions are treated as equations, where the right side is set
	to zero.
++#

linalg::expr2Matrix := proc(eqns)
    name linalg::expr2Matrix;
    local vars, R, exclude, a, t, v, i, j, r, c;
begin
    if testargs() then
	case args(0)
	of 4 do if args(4) <> hold(Include) 
		and (args(4))::hasProp( CommutativeRing ) <> TRUE
		then
		    error("invalid fourth argument")
		end_if
	of 3 do if args(3) <> hold(Include)
		and (args(3))::hasProp( CommutativeRing ) <> TRUE
		then
		    error("invalid third argument")
		end_if
	of 2 do t := args(2); 
		if not contains( {DOM_LIST,DOM_SET},domtype(t) ) then
		    if t <> hold(Include) 
		    and t::hasProp( CommutativeRing ) <> TRUE 
		    then
			error("invalid second argument")
		    end_if
		else
		    if nops(t) = 0 then
			error("missing indeterminates")
		    end_if;
		    for i from 1 to nops(t) do
			if poly(op(t,i)) = FAIL then
			    error("invalid indeterminate: ".expr2text(op(t,i)))
			end_if
		    end_for
		end_if
	of 1 do if not contains( {DOM_LIST,DOM_SET},domtype(eqns) ) then
		    error("expecting a list or set of expressions")
		end_if;
		if nops(eqns) = 0 then
		    error("missing equations")
		end_if;
		break
	otherwise
	    error("wrong no of args")
	end_case
    end_if;

    exclude := TRUE;
    case args(0)
    of 1 do R := ExpressionField();
	    break;
    of 2 do t := args(2);
	    if contains( {DOM_LIST,DOM_SET},domtype(t) ) then
		vars := t; R := ExpressionField();
		break
	    end_if;
	    if t = hold(Include) then
		R := ExpressionField(); exclude := FALSE;
		break
	    end_if;
	    R := t;
	    break
    of 3 do if args(3) = hold(Include) then exclude := FALSE end_if;
	    R := args(3);
	    if contains( {DOM_LIST,DOM_SET},domtype(args(2)) ) then
		vars := args(2);
		if not exclude then
		    R := ExpressionField()
		end_if;
		break
	    end_if;
	    if not exclude then R := args(2) end_if;
	    break
    of 4 do vars := args(2);
	    exclude := FALSE;
	    if args(3) = hold(Include) then 
		R := args(4) 
	    else 
		R := args(3) 
	    end_if
    end_case;

    eqns := [ op(eqns) ];
    r := nops(eqns);

    userinfo(1,"change expressions to equations");

    t := array(1..r,1..1);
    for i from 1 to r do
	if type( eqns[i] ) <> "_equal" then 
	    t[i,1] := 0; 
	    next 
	end_if;
	# save the right side # 
	t[i,1] := op( eqns[i],2 );

	eqns := subsop( eqns, i=op( eqns[i],1 ) )
    end_for;

    if vars = hold(vars) then
	vars := _union( indets(eqns[j],PolyExpr) $ j=1..r )
    end_if;
 
    c := nops(vars);
    a := array(1..r,1..c,[ [R::zero $ c] $ r ]);
 
    userinfo(1,"compute the right and left side of each eq.");

    for i from 1 to r do 
	# get constant coefficient j of i-th equation #
	j := poly( eqns[i],[op(vars)] );
        ( j := coeff(j,0) ) $ hold(k)=1..nops(vars);

	userinfo(1,"constant coefficient of ",i,".th left side = ",j); 

	eqns := subsop( eqns,i=eqns[i]-j );
	j := t[i,1] - j;
	# get constant coefficient v of j #
	v := poly( j,[op(vars)] );
        ( v := coeff(v,0) ) $ hold(k)=1..nops(vars);

	userinfo(1,"new right side: ",v);

        if domtype(v) = R then
            t[i,1] := v;
	else
            t[i,1] := R::convert( v );
            if t[i,1] = FAIL then
                t[i,1] := v::convert_to( v,R );
                if t[i,1] = FAIL then
                    error("unable to convert ".expr2text(v))
                end_if
            end_if
	end_if;

	eqns := subsop( eqns,i=eqns[i]-j+v ); 

	userinfo(1,"new left side: ",eqns[i]);

        for j from 1 to c do
	    userinfo(1,
		"convert ",eqns[i]," to poly and get the lin. coeff"
	    );
            v := poly( eqns[i],[op(vars)] );
            case degree(v,op(vars,j))
            of 0 do a[i,j] := R::zero;
                    break
            of 1 do v := coeff( v,op(vars,j),1 );
                    if domtype(v) = DOM_POLY then
                        if degree(v,[op(vars)]) <> 0 then
                            error("expecting linear equations")
                        end_if;
                        v := expr(v)
                    end_if;
                    if domtype(v) = R then
                        a[i,j] := v;
                        break
                    end_if;
                    a[i,j] := R::convert( v );
                    if a[i,j] = FAIL then
                        a[i,j] := v::convert_to( v,R );
                        if a[i,j] = FAIL then
                            error("unable to convert ".expr2text(v))
                        end_if
                    end_if;
                    break
            otherwise
                error("expecting linear equations")
            end_case;

	    userinfo(1,"linear coeff. = ", a[i,j])

        end_for
    end_for;

    a := domattr(Matrix(R),"newThis")(a);
    if not exclude then
	return( a::concatMatrix( a,a::newThis(map( t,R::negate )) ) )
    end_if;

    [a,a::newThis( t )]
end_proc:

# end of file #
