# $Date: 1995/04/28 09:03:53 $  $Author: zimmerma $  $Revision: 1.7 $ #
# kamo, 08/07/93 #

#++
orthpoly.mu  --  the orthogonal polynomial package
++#

#++
User Functions:
 
chebyshev1(n, x) - generates the nth Chebyshev polynomial of the first kind
chebyshev2(n, x) - generates the nth Chebyshev polynomial of the second kind
gegenbauer(n, a, x) - generates the nth Gegenbauer polynomial
hermite(n, x) - generates the nth Hermite polynomial
jacobi(n, a,b, x) - generates the nth Jacobi polynomial
laguerre(n, a, x) - generates the nth Laguerre polynomial
legendre(n, x) - generates the nth Legendre polynomial
++#

#--
Internal Functions:

Chebyshev1(n, x) - recurrence relation for Chebyshev polynomials of the first kind
Chebyshev2(n, x) - recurrence relation for Chebyshev polynomials of the second kind
Gegenbauer(n, x) - recurrence relation for Gegenbauer polynomials
Hermite(n, x) - recurrence relation for Hermite polynomials
Jacobi(n, a, b, x) - recurrence relation for Jacobi polynomials
Laguerre(n, a, x) - recurrence relation for Laguerre polynomials
--#

proc()
    local path;
begin

orthpoly := domain():

orthpoly::name := "orthpoly":
orthpoly::info := "Library 'orthpoly': orthogonal polynomials":
orthpoly::interface := {
hold(chebyshev1),
hold(chebyshev2),
hold(curtz),
hold(gegenbauer),
hold(hermite),
hold(jacobi),
hold(laguerre),
hold(legendre)}:

path := pathname("ORTHPOLY"):

orthpoly::chebyshev1:= loadproc(orthpoly::chebyshev1, path, "chebysh1"):
orthpoly::chebyshev2:= loadproc(orthpoly::chebyshev2, path, "chebysh2"):
orthpoly::curtz:= loadproc(orthpoly::curtz, path, "curtz"):
orthpoly::gegenbauer:= loadproc(orthpoly::gegenbauer, path, "gegenbau"):
orthpoly::hermite:= loadproc(orthpoly::hermite, path, "hermite"):
orthpoly::jacobi:= loadproc(orthpoly::jacobi, path, "jacobi"):
orthpoly::laguerre:= loadproc(orthpoly::laguerre, path, "laguerre"):
orthpoly::legendre:= loadproc(orthpoly::legendre, path, "legendre"):

end_proc():

