# $Date: 1995/04/04 15:54:26 $  $Author: kg $  $Revision: 1.10 $ #

#++
Type -- the domain of type expressions

A type expression is a CAT_EXT with 3 operands:-

1. an identifier with the name of the type
2. a procedure for testing the type of an expression
3. additional argument for the type testing procedure
4. a boolean value signalling that the type is a kind of _exprseq

The type testing procedure is called to check the type of an
expression. It is called with the 3rd operand of the type
expression and the expression to test as arguments.

The type testing procedure must return TRUE if
the expression has the correct type, FALSE if the expression
has not the correct type and FAIL if the routine can't
decide if the expression has the correct type.
++#

proc()
    local path;
begin

Type:= domain():

Type::name:= "Type":
Type::info:= "Domain 'Type': Type expressions for testing types":
Type::interface:= {
    hold(ListOf), hold(Union), hold(SequenceOf), hold(Product),
    hold(ListProduct), hold(PolyOf), hold(SetOf), hold(PosInt),
    hold(NegInt), hold(NonNegInt), hold(Rational), hold(RealNum),
    hold(ListOfIdents), hold(AnyType), hold(Series)
}:

Type::testtype:= proc(x,T) begin
    if domtype(T) = Type then
	extop(T,2)(extop(T,3), x)
    else
	bool(domtype(x) = T)
    end_if
end_proc:

Type::print:= proc(x) begin
    if extop(x,3) = FALSE then
	extop(x,1)
    else
	extop(x,1)(op(extop(x,3)))
    end_if
end_proc:

Type::isSeqType:= proc(t) begin
    if domtype(t) = Type then extop(t,4) else FALSE end_if
end_proc:

# AnyType matches any type #
Type::AnyType:= new(Type, hold(AnyType), TRUE, FALSE, FALSE):

path := pathname("TYPE"):

Type::ListOf:= loadproc(Type::ListOf, path, "ListOf"):
Type::ListOfIdents:= loadproc(Type::ListOfIdents, path, "ListOfId"):
Type::ListProduct:= loadproc(Type::ListProduct, path, "LstProd"):
Type::SequenceOf:= loadproc(Type::SequenceOf, path, "SequOf"):
Type::Product:= loadproc(Type::Product, path, "Product"):
Type::PolyOf:= loadproc(Type::PolyOf, path, "PolyOf"):
Type::SetOf:= loadproc(Type::SetOf, path, "SetOf"):
Type::Union:= loadproc(Type::Union, path, "Union"):

Type::PosInt:= loadproc(Type::PosInt, path, "PosInt"):
Type::NegInt:= loadproc(Type::NegInt, path, "NegInt"):
Type::NonNegInt:= loadproc(Type::NonNegInt, path, "NoNegInt"):
Type::Rational:= loadproc(Type::Rational, path, "Rational"):
Type::RealNum:= loadproc(Type::RealNum, path, "RealNum"):

Type::Constant:= loadproc(Type::Constant, path, "Constant"):
Type::PolyExpr:= loadproc(Type::PolyExpr, path, "PolyExpr"):
Type::RatExpr:= loadproc(Type::RatExpr, path, "RatExpr"):

Type::Series:= loadproc(Type::Series, path, "Series"):

Type::ODE:= loadproc(Type::ODE, path, "ODE"):
Type::Linear:= loadproc(Type::Linear, path, "Linear"):

end_proc():

# end of file #
