# $Date: 1994/05/31 13:21:35 $  $Author: linus $  $Revision: 1.1 $ #

# kg, 28/06/93 #

#++
isa::set_of -- tests if a set contains elements of a certain type

isa::set_of(s, t [,a...])

s - set
t - type (string or executable)
a - additional argument for executable (optional)

't' may be an executable object or a Domain. If 't' is an
executable it is mapped to each element of the set and must
return TRUE if the element is of the appropriate type.
The otional arguments 'a' are handled as additional arguments
to 't'.

Examples:
>> isa::set_of( {1, 2.2, 3}, DOM_INT);
FALSE
>> isa::set_of( {1, 2.2, 3}, isa::real);
TRUE
++#

isa::set_of:= proc(s, t)
    local i, a;
begin
    if domtype(s) = DOM_SET then
	if domtype(t) = DOM_DOMAIN then
	    for i in s do
		if type(i) <> t then return(FALSE) end_if
	    end_for
	else
	    a:= args(i) $ i=3..args(0);
	    for i in s do
		if not t(i,a) then return(FALSE) end_if
	    end_for
	end_if;
	return(TRUE)
    end_if;
    FALSE
end_proc:

