# $Date: 1994/05/31 13:21:21 $  $Author: linus $  $Revision: 1.1 $ #

# kg, 28/06/93 #

#++
isa::list_of -- tests if a list contains elements of a certain type

isa::list_of(s, t [,a...])

s - list
t - type (string or executable)
a - additional argument for executable (optional)

't' may be an executable object or a Domain. If 't' is an
executable it is mapped to each element of the list and must
return TRUE if the element is of the appropriate type.
The otional arguments 'a' are handled as additional arguments
to 't'.

Examples:
>> isa::list_of( [1, 2.2, 3], DOM_INT);
FALSE
>> isa::list_of( [1, 2.2, 3], isa::real);
TRUE
++#

isa::list_of:= proc(l, t)
    local a, i;
begin
    if domtype(l) = DOM_LIST then
	if domtype(t) = DOM_DOMAIN then
	    for i in l do
		if domtype(i) <> t then return(FALSE) end_if
	    end_for
	else
	    a:= args(i) $ i=3..args(0);
	    for i in l do
		if not t(i, a) then return(FALSE) end_if
	    end_for
	end_if;
	return(TRUE)
    end_if;
    FALSE
end_proc:

