# $Date: 1995/06/07 13:17:44 $ $Author: zimmerma $ $Revision: 1.7 $ #
#--
intlib::tower(f) - constructs the tower of field extensions in which f is an 
element.
--#
intlib::tower:=proc(f)
  local i,j,L,x,T;
# global n,k,k_sub,k_ident,k_diff,k_deg,k_alg,Q,Q_sub; #
begin
  L:=null();
  for i in f do
    case domtype(i)
      of DOM_EXPR    do case (j:=intlib::tower(i))
                          of FAIL  do return(FAIL);
                          of FALSE do return(FALSE);
                          otherwise   L:=L,j;
                        end_case; break;
      of DOM_INT     do ;
      of DOM_RAT     do L:=L,i; break;
      of DOM_COMPLEX do if (j:=contains(Q,I))>0
                          then L:=L,op(i,1)+op(i,2)*Q_sub[j];
                          else x:=genident(); L:=L,op(i,1)+op(i,2)*x;
                               Q:=append(Q,I); Q_sub:=append(Q_sub,x);
                        end_if; break;
      of DOM_IDENT   do if (j:=contains(Q,i))>0 then L:=L,Q_sub[j];break;end_if;
                        if contains(Q_sub,i)>0 then L:=L,i;        break;end_if;
                        if contains(k,i)>0 then L:=L,i;            break;end_if;
                        if contains(k_sub,i)>0 then L:=L,i;        break;end_if;
                        x:=genident(); L:=L,x;
                        Q:=append(Q,i); Q_sub:=append(Q_sub,x);    break;
      of DOM_FLOAT   do return(FAIL);
      otherwise         return(FAIL);
    end_case; 
  end_for;
  case op(f,0)
    of hold(ln)       do i:=numer(L); j:=denom(L);
                         if domtype(i)<>DOM_EXPR and domtype(i)<>DOM_IDENT or
                            domtype(j)<>DOM_EXPR and domtype(j)<>DOM_IDENT
                           then return(intlib::insert(0,hold(ln),i/j));
                           else return(intlib::insert(0,hold(ln),i)
                                      -intlib::insert(0,hold(ln),j));
                         end_if;
    of hold(exp)      do return(intlib::insert(1,hold(exp),normal(L)));
    of hold(tan)      do return(intlib::insert(2,hold(tan),normal(L)));
    of hold(atan)     do return(intlib::insert(0,hold(atan),normal(L)));

    of hold(_plus)    do return(intlib::algred(_plus(L),n));
    of hold(_mult)    do return(intlib::algred(_mult(L),n));
    of hold(_power)   do if domtype(L[2])=DOM_INT
                           then return(L[1]^L[2])
                           else return(intlib::tower(hold(exp)(L[2]*ln(L[1]))));
                         end_if;
    of FAIL           do if domtype(f)=DOM_LIST then return([L]);
                                                else return(f);
                         end_if;
    otherwise            return(FAIL);
  end_case;
end_proc:
