# $Date: 1994/10/03 22:54:00 $ $Author: kraume $ $Revision: 1.2 $ #
#--
intlib::split1(f,n) - computes the split factorization of the function f in the 
field extension k[n] and yields the canonical representation as the sequence
numerator and denominator of the special part and numerator and denominator of
the normal part. The denominators are tables of squarefree polynomials.
M. Bronstein, A Unification of Liouvillian Extension, AAECC 1990, 1
--#
intlib::split1:=proc(f,n)
  local  i,P,S,N;
# global k_sub,k_deg; #
begin
  P:=poly(denom(f),[k_sub[n]]);
  N:=1/lcoeff(P);
  P:=intlib::sim(multcoeffs(P,N));
  f:=intlib::sim(multcoeffs(poly(numer(f),[k_sub[n]]),N));
  S[0]:=poly(1,[k_sub[n]]);
  if degree(P)=0 then return(f,S[0],poly(0,[k_sub[n]]),S); end_if;
  if k_deg[n]=0  then f:=intlib::sim(divide(f,P));
                      return(f[1],S[0],f[2],intlib::sqffTab(P));
  end_if;
  P:=intlib::sqffTab(P);
  for i from 1 to nops(P) do
    S[i]:=intlib::gcdk_n(P[i],intlib::diffs(P[i],n));
    N[i]:=intlib::sim(divide(P[i],S[i])[1]);
  end_for;
  N[0]:=S[0];
  for i from 1 to nops(P) do
    S[0]:=S[0]*S[i]^i;
    N[0]:=N[0]*N[i]^i;
  end_for;
# now S is the special part and N is the normal part of the denominator of f #
  P:=intlib::gcdex(S[0],N[0]);
  i:=intlib::sim(divide(P[2]*f,N[0]));
  N[0]:=NIL;
  return(intlib::sim(P[3]*f+i[1]*S[0]),S[0],i[2],N);
end_proc:
