# $Date: 1994/10/03 22:53:47 $ $Author: kraume $ $Revision: 1.2 $ #
#--
intlib::pde_ln(A,B,C,n,m) - solves the polynomial differential equation AY'+BY=C
when the degrees of A and B as polynomials in the last extension are zero and 
this extension is an logarithmic monomial.
It call's the procedure solve_Rde recursiv.
M. Bronstein, The Transcendental Risch Differential Equation, Journal of
Symbolic Computation, 1990, 9
--#
intlib::pde_ln:=proc(A,B,C,n,m)
  local c,y,Y,i;
# global k_sub,k_diff; #
begin
#tt
  if test
    then print(Unquoted,"n=",n,
              "enter procedure pde_ln with",A,"Y'+",B,"Y=",C,"with bound m=",m)
  end_if;
  if (c:=degree(C))>m
    then intlib::_proof("can't solve the Rde:",
                         A,B,C,n,"because the bound is to low");
  end_if;
tt#
  if (c:=degree(C))>m then return(FAIL); end_if;
  A:=expr(A); B:=expr(B);
  y:=intlib::solveRde(B/A,lcoeff(C)/A,n-1);
#tt
  if y=FAIL
    then intlib::_proof("can't solve the polynomial differential equation",
                         A,B,C,n);
  end_if;
tt#
  if y=FAIL then return(FAIL); end_if;
  Y:=y*k_sub[n]^c;
  for i from c-1 downto 0 do
    y:=intlib::solveRde(B/A,coeff(C,i)/A-(i+1)*k_diff[n]*y,n-1);
#tt
    if y=FAIL
      then intlib::_proof("can't solve the polynomial differential equation",
                           A,B,C,n); 
    end_if;
tt#
    if y=FAIL then return(FAIL); end_if;
    Y:=Y+y*k_sub[n]^i;
  end_for;
  return(Y);
end_proc:
