# $Date: 1994/10/03 22:53:45 $ $Author: kraume $ $Revision: 1.2 $ #
#--
intlib::linsys(A,B,opt) - computes the solution X of the system of linear 
equations A*X=B. It delivers FAIL when there is no solution.
If the Option Std is given, it computes only the main solution.                          
     ->j                  
  | | [s,t]            |  
  V |       .          |  
  i |          .       |  
    |            [m,n] |  
                          
--#
intlib::linsys:=proc(A,B,Std)
  local s,t,m,n,i,j,jj,k,kk,column,chind,ind;
begin
  if testargs()
    then if (domtype(A)<>DOM_ARRAY) or (domtype(B)<>DOM_ARRAY)
           then error("not an array");
         end_if;
         if op(A,[0,1])<>2 or op(B,[0,1])<>1
           then error("wrong dimension");
         end_if;
         if op(A,[0,2])<>op(B,[0,2])
           then error("incompatible range");
         end_if;
         if args(0)>2 and Std<>hold(Std)
           then error("wrong option");
         end_if;
         if args(0)>3
           then error("too many arguments");
         end_if;
  end_if;
  s:=op(A,[0,2,1]); t:=op(A,[0,3,1]); m:=op(A,[0,2,2]); n:=op(A,[0,3,2]);
  k:=s; kk:=1;
# computation of the echelon form #
  for j from t to n do
    column:=TRUE;
    for i from k to m do
      if A[i,j]<>0 then column:=i; break; end_if;
    end_for;
    if column = TRUE
      then ind[kk]:=j; kk:=kk+1; next;
      else chind[k]:=j;
           if column > k
             then for jj from j to n do
                    A[column,jj]; A[column,jj]:=A[k,jj]; A[k,jj]:=%2;
                  end_for;
                  B[column]; B[column]:=B[k]; B[k]:=%2;
           end_if;
           if A[k,j]<>1
             then for jj from j+1 to n do
                    A[k,jj]:=A[k,jj]/A[k,j];
                  end_for;
                  B[k]:=B[k]/A[k,j];
                  A[k,j]:=1;
           end_if;
           if k<m
             then for i from k+1 to m do
                    for jj from j+1 to n do
                      A[i,jj]:=A[i,jj]-A[k,jj]*A[i,j];
                    end_for;
                    B[i]:=B[i]-B[k]*A[i,j];
                    A[i,j]:=0;
                  end_for;
             else for jj from j+1 to n do
                    ind[kk]:=jj; kk:=kk+1;
                  end_for;
                  k:=k+1;
                  break;
           end_if;
           k:=k+1;
    end_if;
  end_for;
  for i from k to m do
    if B[i]<>0 then return(FAIL) end_if;
  end_for;
# #
  for j from k-1 downto s+1 do
    for i from s to j-1 do
      for jj from chind[j]+1 to n do
        A[i,jj]:=A[i,jj]-A[i,chind[j]]*A[j,jj];
      end_for;
      B[i]:=B[i]-A[i,chind[j]]*B[j];
      A[i,chind[j]]:=0;
    end_for;
  end_for;
# computation of the solution respectively the basis of the solutions #
  column:=array(op(A,[0,3]),(chind[i])=B[i] $ hold(i)=s..k-1,
                            (ind[i])=0 $ hold(i)=1..n-t+s-k+1);
  if Std=hold(Std)
    then return(column);
    else return(column,
                array(op(A,[0,3]),(chind[i])=A[i,ind[j]] $ hold(i)=s..k-1,
                                  (ind[i])=0             $ hold(i)=1..n-t+s-k+1,
                                  (ind[j])= -1        ) $ hold(j)=1..n-t+s-k+1);
  end_if;
end_proc:
