# $Date: 1994/10/03 22:53:38 $ $Author: kraume $ $Revision: 1.2 $ #
#--
intlib::gcdk_n(a,b) - computes the GCD of two polynomials a and b over one 
variable.
K.O. Geddes, Algorithms for Computer Algebra, Algorithm 2.3
--#
intlib::gcdk_n:= proc(a,b)
  local c,d,r;
begin
  if iszero(a)
    then return(b);
    elif iszero(b) then return(a);
  end_if;
  c:=intlib::sim(multcoeffs(a,1/lcoeff(a))); 
  d:=intlib::sim(multcoeffs(b,1/lcoeff(b)));
  while not iszero(d) do
    r:=intlib::sim(divide(c,d,Rem));
    c:= d; d:= r;
  end_while;
  intlib::sim(multcoeffs(c,1/lcoeff(c)));
end_proc:
