# $Date: 1995/06/07 13:17:54 $ $Author: zimmerma $ $Revision: 1.4 $ #
#--
intlib::algdep(f,n) - tests whether f is transcendental or algebraic over k[n].
It returns
* "the representation in k[n]",1 - if f is in k[n],
* P,s - so that f^s-P=0 if f is in the algebraic closure of k[n]
* f,0 - if f is transcendental over k[n].
--#
intlib::algdep:=proc(f,n)
  local i,x,P,s,t,A,B,C; 
# global k,k_sub,k_ident,k_diff,k_alg,Q,Q_sub; # 
begin
  if n<2 then return(f,0); end_if;
  case op(f,0)
    of hold(ln)  do  P:=intlib::diffs(op(f),n)/op(f); break;
    of hold(exp) do  P:=intlib::diffs(op(f),n); break;
    otherwise return(f,0);
  end_case;
#tt
  if test then print(Unquoted,"tm",P); end_if;
tt#
  for i from 2 to n do
    if contains({hold(exp),hold(ln)},op(k[i],0)) and (k_alg[i]=0)
      then P:=P+k_ident[i]*k_diff[i];
    end_if;
  end_for;
#tt
  if test then print(Unquoted,"tm",P); end_if;
tt#
  P:=intlib::algred(P,n); P:=poly(numer(P),k_sub);
#tt
  if test then print(Unquoted,"tm",P); end_if;
tt#
  A:=array(1..nterms(P),2..n); B:=array(1..nterms(P));
  for s from 1 to nterms(P) do
    i:=poly(nthcoeff(P,s),[k_ident[2]]);
    for t from 2 to n-1 do
      A[s,t]:=coeff(i,1); i:=poly(coeff(i,0),[k_ident[t+1]]);
    end_for;
    A[s,n]:=coeff(i,1); B[s]:=-coeff(i,0);
  end_for;
#tt
  if test then print(Unquoted,"tm A=",A,"B=",B); end_if;
tt#
  B:=intlib::linsys(A,B,hold(Std));
#tt
  if test then print(Unquoted,"Losung--->",B); end_if;
tt#
  if B=FAIL then return(f,0); end_if;
  i:=map({op(B)},type);
  if i minus {DOM_INT,DOM_RAT} <> {} then return(f,0); end_if;
  if i minus {DOM_INT} = {} then s:=1;
                            else s:=ilcm(1,denom(B[i]) $ hold(i)=2..n);
  end_if;
  case op(f,0)
    of hold(ln)  do
      A:=1;P:=0;
      for i from 2 to n do
        case op(k[i],0)
          of hold(ln)  do A:=A*op(k[i])^(B[i]*s); P:=P-B[i]*k_sub[i]; break;
          of hold(exp) do A:=A*k_sub[i]^(B[i]*s); P:=P-B[i]*op(k[i]); break;
        end_case;
      end_for;
      C:=intlib::algred(op(f)^s*A,n);
#tt
      if test then print("const=",C); end_if;
tt#
      if C=1 then return(P,1); end_if;
      if (i:=contains(Q,ln(C)))>0
        then return(Q_sub[i]/s+P,1);
        else x:=genident(); Q:=append(Q,ln(C)); Q_sub:=append(Q_sub,x);
             return(x/s+P,1);
      end_if;
    of hold(exp) do
      A:=0;P:=1;
      for i from 2 to n do
        case op(k[i],0)
          of hold(ln)  do A:=A+B[i]*k_sub[i]; P:=P*op(k[i])^(-B[i]); break;
          of hold(exp) do A:=A+B[i]*op(k[i]); P:=P*k_sub[i]^(-B[i]); break;
        end_case;
      end_for;
      C:=intlib::algred(op(f)+A,n);
#tt
      if test then print("const=",C); end_if;
tt#
      if C=0 then return(P^s,s); end_if;
      if (i:=contains(Q,exp(C)))>0
        then return((Q_sub[i]*P)^s,s);
        else x:=genident(); Q:=append(Q,exp(C)); Q_sub:=append(Q_sub,x);
             return(x^s*P^s,s);
      end_if;
    otherwise  return(f,0);
  end_case;
end_proc:
