# $Date: 1995/05/04 07:33:39 $ $Author: kg $ $Revision: 1.6 $ #

# kg, 31/12/93 #

#++
update -- update pair list by inserting new pairs, removing redundant pairs

update(P, G, h)

P   - sorted list of critical pairs
G   - list of polynomials
h   - sugared polynomial to insert into G

update returns the updated pair list P.
This is algorithm 5.7 (UPDATE) of Becker et al (p232).

A critical pair is represented by a list [pi,pj,lij,s]:
- sugared polynomials pi and pj
- lij is the lcm of lcoeff(pi) and lcoeff(pj)
- s is the sugar of the s-polynomial of pi and pj
++#

groebner::update:= proc(P, G, h)
    local n, lh, lcmh, i, j, k, Q, R, lcmp, skip, p, t;
begin
    n:= nops(G);
    lh:= h[2];
    lcmh:= table();

    # create new pairs #
    Q:= {};
    for p in G do
        t:= groebner::term_lcm(p[2], lh);
        lcmh[p[2]]:= t;
        Q:= Q union {[p, h, t]}
    end_for;
    Q:= [op(Q)];

    # remove redundant new pairs #
    R:= {};
    for j from 1 to n do
    	p:= Q[j];
	lcmp:= p[3];

	if lh * p[1][2] <> lcmp then
	    skip:= FALSE;
	    for k from j+1 to n do
		if divide(lcmp, Q[k][3], Exact) <> FAIL then
		    skip:= TRUE;
		    break
		end_if;
	    end_for;
	    if skip then next end_if;

	    for k in R do
		if divide(lcmp, k[3], Exact) <> FAIL then
		    skip:= TRUE;
		    break
		end_if;
	    end_for;
	    if skip then next end_if;
	end_if;

	R:= R union {p};
    end_for;

    # remove new pairs which leading terms are disjoined #
    Q:= {};
    n:= h[3];
    for p in R do
        if lh * p[1][2] <> p[3] then
            # add sugar of s-polynomial #
            j:= p[1];
            k:= p[3];
            t:= max(j[3] + degree(divide(k, j[2], Exact)),
		    n + degree(divide(k, lh, Exact)));
            Q:= Q union {append(p, t)}
        end_if
    end_for;
    
    # remove redundant old pairs #
    R:= [];
    for p in P do
        if divide(p[3], lh, Exact) <> FAIL then
    	    t:= p[1][2];
    	    if not contains(lcmh, t) then
    	        lcmh[t]:= groebner::term_lcm(t, lh)
    	    end_if;
    	    if lcmh[t] <> p[3] then
		t:= p[2][2];
		if not contains(lcmh, t) then
		    lcmh[t]:= groebner::term_lcm(t, lh)
		end_if;
		if lcmh[t] <> p[3] then
    	            next
    	        end_if
    	    end_if
        end_if;
	R:= append(R, p);
    end_for;
        
    # insert new pairs #
    if nops(Q) <> 0 then
	Q:= sort([op(Q)], groebner::pair_less);
	
	# merge new pairs into old ones #
	j:= 1;
	k:= 1;
	P:= [];
	while j <= nops(Q) and k <= nops(R) do
	    if groebner::pair_less(Q[j], R[k]) then
	    	P:= append(P, Q[j]);
	    	j:= j+1
	    else
	        P:= append(P, R[k]);
	        k:= k+1
	    end_if
	end_while;
	R:= append(P, op(Q,j..nops(Q)), op(R,k..nops(R)))
    end_if;

    # update basis #
    Q:= select(G, fun(divide(args(1)[2], lh, Exact) = FAIL));

    R, append(Q, h)
end_proc:

# end of file #
