# $Date: 1995/03/21 16:05:08 $ $Author: kg $ $Revision: 1.7 $ #

# kg, 29/12/93 #

#++
spoly -- returns S-polynomial of p and q
 
spoly(p, q [,o])
 
p,q - polynomials
o   - otional term ordering (LexOrder, DegInvLexOrder or DegreeOrder)

'DegInvLexOrder' is used if no order is given.
++#
 
groebner::spoly:= proc(p, q, o)
    local order, conv;
begin
    if args(0) = 2 then o:= hold(DegInvLexOrder) end_if;
    if testargs() then
	if args(0) <> 3 and args(0) <> 2 then error("wrong no of args") end_if;
	if domtype(p) = DOM_POLY then
	    groebner::test_poly(p);
	    groebner::test_poly(q);
	    if op(p, 2..3) <> op(q, 2..3) then
		error("polynomial types don't match")
	    end_if;
	    if domtype(op(p,3)) = DOM_DOMAIN then
		groebner::test_domain(op(p,3))
	    end_if;
	end_if;
	if not contains({hold(DegreeOrder), hold(LexOrder), hold(DegInvLexOrder)}, o) then
	    error("unknown order")
	end_if
    end_if;

    if domtype(p) <> DOM_POLY then
	p:= gcdlib::expr2polys([p, q], Type::Rational);
	if p = FAIL then error("not a rational polynomial") end_if;
	q:= p[2];
	p:= p[1];
	conv:= expr
    else
	conv:= id
    end_if;

    # set actual order #
    order:= groebner::order;
    groebner::order:= o;

    p:= [p, lterm(p, o), 0];
    q:= [q, lterm(q, o), 0];
    s:= groebner::s_poly([p, q, groebner::term_lcm(p[2], q[2]), 0]);
    
    # re-install original order #
    groebner::order:= order;
    
    conv(s[1])
end_proc:

# end of file #
