# $Date: 1995/03/13 13:53:21 $ $Author: kg $ $Revision: 1.5 $ #

# kg, 23/12/93 #

#--
reduce -- fully reduces sugared polynomial p modulo polynomials in set S

reduce(p, S)

p   - sugared polynomial
S   - reducing set (base of ideal)

This is algorithm 10.1 (Reduce) of Geddes et al (p436). It ist _the_
time critical operation of the basis computation.

The reducing set is a list of lists [l1,...,ln]. Each sublist li contains
those sugared polynomials with total degree i of the leading term.
--#

groebner::reduce:= proc(p, S)
    local q, d, lp, o, n, i, e, s;
begin
    lp:= p[2]; s:= p[3]; p:= p[1];
    o:= groebner::order;
    q:= groebner::zero;
    n:= nops(S);
    while not iszero(p) do
	# find reducing polynomial e in S #
	d:= FAIL;
	for i from min(degree(lp), n) downto 1 do
	    for e in S[i] do
		d:= divide(lp, e[2], Exact);
		if d <> FAIL then
		    e:= e[1];
		    break
		end_if
	    end_for;
	    if d <> FAIL then break end_if
	end_for;

	if d = FAIL then
	    # remove irreducible monomial #
	    lp:= lmonomial(p,o);
	    p:= p - lp;
	    q:= q + lp;
	else
	    # reduce p via e #
	    p:= p + e * multcoeffs(d, - lcoeff(p,o)/lcoeff(e,o));
	end_if;
	lp:= lterm(p,o);
    end_while;
    [q, lterm(q,o), s]
end_proc:

# end of file #
