# $Date: 1995/03/13 13:53:14 $ $Author: kg $ $Revision: 1.6 $ #

# kg, 27/12/93 #

#--
basis - returns non-reduced Gr"obner-basis for polynomials in list S

basis(S)

S - list of polynomials

This is algorithm 5.8 (GR"OBNERNEW2) of Becker et al (p232). The only
difference is that any reduced S-polynomials (even redundant ones) are 
used in further reductions.

The "sugar cube" selection strategy is used to select critical pairs.
A sugared polynomial is represented as a list containing of:-
 - the polynomial p,
 - the leading term of p,
 - the sugar of p.
--#

groebner::basis:= proc(S)
    local i, G, P, h, lh, n;
begin
    # sort S #
    S:= map(S, fun([args(1), lterm(args(1), groebner::order), degree(args(1))]));
    n:= nops(S);
    if n <= 1 then return(S) end_if;
    S:= sort(S, not groebner::term_less);

    # build initial pair list #
    P:= [];
    G:= [S[1]];
    for h from 2 to n do
	P:= groebner::update(P, G, S[h]);
	G:= P[2];
	P:= P[1];
    end_for;

    # create reducing set #
    S:= [];
    for h in G do
    	if degree(h[2]) = 0 then return([h]) end_if;
    	S:= groebner::redset_insert(S, h)
    end_for;

    # do reductions #
    while nops(P) <> 0 do
	# select the minimal critical pair #
        h:= groebner::s_poly(P[1]);
        P[1]:= NIL;
        if iszero(h[1]) then next end_if;
        
	h:= groebner::reduce(h, S);
	if not iszero(h[1]) then
	    h[1]:= groebner::monic(h[1]);
	    if degree(h[2]) = 0 then return([h]) end_if;
	    P:= groebner::update(P, G, h);
	    G:= P[2];
	    P:= P[1];
	    S:= groebner::redset_insert(S, h);
	end_if;
    end_while;

    G
end_proc:

# end of file #
