# $Date: 1994/05/31 13:20:02 $ $Author: linus $ $Revision: 1.1 $ #

# kg, 09/12/93 #

#--
gcdlib::vanderm_mod_solve -- solve transpose Vandermonde system over Zp

gcdlib::vanderm_mod_solve(A,b,p)

A - list of coefficients of transpose Vandermonde matrix
b - list of right hand sides
p - modulus

gcdlib::vanderm_mod_solve solves a linear transpose Vandermonde system
over Zp. The transpose Vandermonde System is given by 

    A[1]^j * x[1] + ... + A[n]^j * x[n] = b[j+1], j=0..n-1

The algorithm is given by Zippel in his book "Algebraic Computation".
--#

gcdlib::vanderm_mod_solve:= proc(A, b, p)
    local n, x, i, j, vpl, vpj, z;
begin
    n:= nops(A);
    if n = 1 then return([b[1]]) end_if;

    # the system is solvable iff the coefficients are distinct #
    if nops({op(A)}) <> n then return(FAIL) end_if;

    vpl:= [ poly(z-A[i],[z],IntMod(p)) $ i=1..n ];

    x:= [];
    for j from 1 to n do
	vpj:= _mult((vpl[i] $ i=1..j-1), (vpl[i] $ i=j+1..n));
	vpj:= multcoeffs(vpj, 1/evalp(vpj, z=A[j]));
	x:= append(x, _plus((b[i] * coeff(vpj,z,i-1)) $ i=1..n) mod p)
    end_for
end_proc:

# end of file #
