# $Date: 1994/09/14 15:26:28 $ $Author: kg $ $Revision: 1.3 $ #

# kg, 09/12/93 #

#--
gcdlib::mod_gcd -- compute the gcd of IntMod-polynomials
 
gcdlib::mod_gcd(p1, p2)
 
p1,p2 - non-zero polynomials over IntMod
 
gcdlib::mod_gcd computes the gcd of 2 non-zero polynomials
over IntMod(p). p must be prime. The arguments are not checked further.
--#
 
gcdlib::mod_gcd:= proc(a, b)
    local g, n, p, tries;
begin
    # use Euclidean alg. for univariate polynomials #
    n:= nops(op(a,2));
    if n = 1 then
	g:= gcdlib::univ_mod_gcd(a, b);
    else

	# create random number generator #
	p:= op(a,[3,1]);
	if not contains(gcdlib::gen_random, p) then
	    gcdlib::gen_random[p]:= random(p)
	end_if;

	# use dense interpolation for small fields (modulus < 2^16-1) #
	if p < 65536 then
	    g:= gcdlib::mod_dense_gcd(a, b);
	else

	    # try sparse interpolation until good starting point is found #
	    tries:= 1;
	    repeat
		tries:= tries+1;
		if tries > 6 then
		    g:= gcdlib::mod_dense_gcd(a, b)
		else
		    g:= gcdlib::mod_sparse_gcd(a, b)
		end_if;
	    until g <> FAIL end_repeat;
	end_if;
    end_if;

    # normalize result #
    multcoeffs(g, 1/lcoeff(g))
end_proc:

# end of file #
