# $Date: 1994/05/31 13:19:56 $ $Author: linus $ $Revision: 1.1 $ #

# kg, 09/12/93 #

#--
gcdlib::mod_dense_gcd -- compute the gcd of IntMod-polynomials using
	dense Newton interpolation

gcdlib::mod_dense_gcd(p1, p2)

p1,p2 - non-zero polynomials over IntMod

gcdlib::mod_dense_gcd computes the gcd of 2 non-zero polynomials over
IntMod(p). p must be prime. The arguments are not checked further.
Dense Newton interpolation is used to calculate the gcd.

See K.O.Geddes et al "Alg. for Computer Algebra", Kluwer 1992, pp307
--#

gcdlib::mod_dense_gcd:= proc(a, b)
    local p, T, Tx, x, X, nv, av, bv, ca, cb, g, gv, 
          c, cv, h, ph, q, n, m, lim, v, V, ni, halt_interp;
begin
    X:= op(a,2);
    nv:= nops(X);
    if nv = 1 then return(gcdlib::univ_mod_gcd(a, b)) end_if;

    T:= op(a,2..3);
    p:= op(T,[2,1]);
    x:= op(X, nv);
    Tx:= [ op(X, 1..nv-1) ], Poly([x], IntMod(p));

    # nomalize args #
    a:= multcoeffs(a, 1/lcoeff(a));
    b:= multcoeffs(b, 1/lcoeff(b));

    # compute contents of a and b, viewed as polynomials in x1,...,x(nv-1)
      over Zp[x] #
    av:= poly(a, Tx);
    bv:= poly(b, Tx);
    g:= poly(1, [x], IntMod(p));

    if lcoeff(av) = g or lcoeff(bv) = g then
	c:= poly(1,T);
    else
	ca:= gcdlib::poly_mod_content(av);
	cb:= gcdlib::poly_mod_content(bv);
	c:= gcdlib::univ_mod_gcd(ca, cb);
	c:= poly(multcoeffs(c, 1/lcoeff(c)), T);

	# remove contents from av and bv #
	av:= mapcoeffs(av, divide, ca, Quo);
	bv:= mapcoeffs(bv, divide, cb, Quo);
	g:= gcdlib::univ_mod_gcd(lcoeff(av), lcoeff(bv));
	g:= multcoeffs(g, 1/lcoeff(g));

	# view a and b as polynomials in X over Zp again #
	a:= poly(av, T);
	b:= poly(bv, T);
    end_if;

    n:= min(degree(a,X[nv-1]), degree(b,X[nv-1]));
    lim:= min(degree(a,x), degree(b,x));

    # dense interpolation loop #
    q:= poly(1, T);
    h:= poly(0, T);
    V:= {};
    ni:= 0;

    while TRUE do

	# get new evaluation point v #
	repeat
	    v:= gcdlib::gen_random[p]();
	    gv:= evalp(g, x=v);
	until not contains(V, v) and gv <> 0 end_repeat;

	# evaluate a and b at v #
	av:= evalp(a, x=v);
	bv:= evalp(b, x=v);

	# get gcd of evaluated polynomials and normalize it #
	cv:= gcdlib::mod_dense_gcd(av, bv);
	cv:= multcoeffs(cv, gv / lcoeff(cv));
	m:= degree(cv, X[nv-1]);

	# test for unlucky homomorphisms #
	halt_interp:= FALSE;
	if m < n then
	    q:= poly(1, T);
	    h:= poly(0, T);
	    V:= {};
	    ni:= 0;
	    n:= m;
	elif m = n then

	    # polynomial Newton interpolation #
	    ni:= ni+1;

	    # compute Newton coefficient #
	    cv:= cv - evalp(h, x=v);
	    if nops(V) > 0 then
		_mult(op(map(V, -_plus, -v)));
		cv:= multcoeffs(cv, 1/%)
	    end_if;

	    # update polynomial #
	    if iszero(cv) then
		halt_interp:= TRUE
	    else
		h:= h + poly(cv, T) * q;
		if ni > lim then halt_interp:= TRUE end_if;
	    end_if;

	    q:= poly(x-v, T) * q;
	    V:= V union { v };
	end_if;

	# did we get the result? #
	if halt_interp then

	    # get primitive part of h, viewed as polynomial in x1,...,x(nv-1)
	      over Zp[x] #
	    ph:= poly(h, Tx);
	    ph:= mapcoeffs(ph, divide, gcdlib::poly_mod_content(ph), Quo);
	    ph:= poly(ph, T);

	    # test division #
	    if divide(a, ph, Exact) <> FAIL then
		if divide(b, ph, Exact) <> FAIL then
		    return(c*ph)
		end_if
	    end_if;

	    if m = 0 then
		return(c)
	    end_if;
	end_if
    end_while
end_proc:

# end of file #
