# $Date: 1994/09/14 15:26:27 $ $Author: kg $ $Revision: 1.3 $ #

# kg, 09/12/93 #

#--
gcdlib::int_gcd -- compute the gcd of two polynomials over the integers

gcdlib::int_gcd(p1, p2)

p1,p2 - non-zero polynomials of type 'Expr' over the integers

gcdlib::int_gcd computes the gcd of 2 non-zero polynomials over the integers.
The arguments are not checked.
--#

gcdlib::int_gcd:= proc(a, b)
    local ca, cb, g;
begin
    if nops(op(a,2)) < 5 then

	# try heuristic and use sparse modular alg. if it fails #
    	ca:= icontent(a);
    	cb:= icontent(b);
    	a:= multcoeffs(a, 1/ca);
    	b:= multcoeffs(b, 1/cb);

	g:= gcdlib::heu_gcd(a, b);
	if domtype(g) = DOM_POLY then
	    g:= multcoeffs(g, igcd(ca, cb)/icontent(g));
	else
	    g:= multcoeffs(gcdlib::int_mod_gcd(a, b), igcd(ca, cb));
	end_if;
    else
	g:= gcdlib::int_mod_gcd(a, b)
    end_if;
    if lcoeff(g) < 0 then -g else g end_if
end_proc:

# end of file #
