# $Date: 1995/03/21 14:53:52 $ $Author: kg $ $Revision: 1.3 $ #

# kg, 27/07/94 #

#--
expr2polys -- convert arguments to polynomials of common type

expr2polys(l [, T])

l - list of expressions
T - type expression or domain (default is Type::AnyType)

expr2polys returns a list of polynomials with a common list of indets
and coefficient ring 'Expr' where the coefficients are of type T.
expr2polys returns FAIL if the expression are no polynomial expressions
or the coefficient type is wrong.
--#

gcdlib::expr2polys:= proc(l, T)
    local a, ind, t;
begin
    # convert expr to polys #
    a:= map(l, poly, hold(Expr));
    if contains(a, FAIL) <> 0 then
	# remove FAIL's #
	a:= { op(a) } minus { FAIL };
	if nops(a) = 0 then return(FAIL) end_if;

	# convert to common indets #
	t:= map(a, op, 2);
	if nops(t) = 1 then
	    ind:= op(t)
	else
	    ind:= [ op(map(t, op)) ]
	end_if;
	a:= map(l, poly, ind, hold(Expr));
	if contains(a, FAIL) <> 0 then return(FAIL) end_if;
    else
	# convert if indets differ #
	t:= { op(map(a, op, 2)) };
	if nops(t) > 1 then
	    ind:= [ op(map(t, op)) ];
	    a:= map(l, poly, ind, hold(Expr));
	end_if;
    end_if;
    if args(0) = 2 then
	if contains(map(map(a, coeff), testtype, T), FALSE) <> 0 then
	    return(FAIL)
	end_if;
    end_if;
    a
end_proc:

# end of file #
