# $Date: 1994/11/08 17:30:41 $ $ Author: yuan $ #

#-- 
faclib::ufactor--return the univariate polynomial factorization, output is a
                 list of factors in polynomial form. 
                  
faclib::ufactor(a,x): a -univariate primitive square free polynomial in Z 
                      x -the indeterminate

faclib::ufactor at first get the linear factors, then check the irreducibility, 
and then factorize the input polynomial into distinct degree factors for three
suitable prime numbers, split the one with the fewest factors, then lift these
factors from Zp to Z by using parallel lifting method(faclib::plift)
--#                   

faclib::ufactor:=proc(a,x)
local d, deg, factors, fpoly, fs, i, j, lc, lfs, minfs, np, p, pos_g, ppoly, m; 
begin
    # using faclib::linear get the linear factors #
    lfs:=faclib::linear(a,x);
    fs:=[lfs[i]$hold(i)=3..nops(lfs)];
    if degree((a:=lfs[2]))=0 then 
       return(fs); 
    end_if;
    if degree(a)<4 then 
       return(append(fs,a));
    elif # test the irreducibility of a(x) at first #
         faclib::irr_test(a,x) then 
         return(append(fs,a)); 
    end_if;
    p:=1; 
    # pos_g is the possible degrees of the factors of a(x) now may have #
    pos_g:={$2..degree(a)}; 
    minfs:=degree(a); 
    lc:=lcoeff(a); 
    # choose three prime numbers #
    for i from 1 to 3 do
        # choose the prime number p such that a(x) in Zp remains #
        # square free and has the same degree as a(x) in Z, (the #
        # first one may have been chosen in faclib::linear)      #
        if i=1 and fs=[] then 
               p:=lfs[1];
               ppoly:=poly(a,IntMod(p));
        else repeat p:=faclib::getprime(lc,p); 
                    ppoly:=poly(a,IntMod(p));
             until degree(gcd(ppoly,Dpoly([1],ppoly)))=0 end_repeat;
                                  # diff(ppoly,x) #
        end_if;
        # use faclib::ddf to do partial factorization in Zp,  #
        # and get the number of factors of a(x) in Zp and the #
        # possible degrees of factors of a(x) in Z may have   # 
        ppoly:=faclib::ddf(multcoeffs(ppoly,1/lcoeff(ppoly)),p,x);
        deg:=[(ppoly[1][m][2]$degree(ppoly[1][m][1])/ppoly[1][m][2])\
                             $hold(m)=1..nops(ppoly[1])]; 
        d:={0};
        for j in deg do 
            d:=d union map(d,_plus,j); 
        end_for;
        # if the possible degree is only the degree #
        # of a(x), then a(x) is irreducible         #
        if (pos_g:=pos_g intersect d)={degree(a)} then 
           return(append(fs,a)); 
        end_if;
        if nops(deg)<=minfs then 
           minfs:=nops(deg); 
           fpoly:=ppoly; 
        end_if; 
    end_for;
    # choose the prime number with the minimum number of factors to split the  #
    # distinct degree factors,  for the product of all monic irrducible        #
    # factors of degree 1 evaluate the polynomial to obtain the linear factors #
    #  (faclib::eval_root) is more efficient, otherwise use faclib::canzas     #
    p:=op(fpoly[1][1][1],[3,1]);
    if fpoly[1][1][2]=1 then 
       if degree(fpoly[1][1][1])=1 then 
          factors:=[fpoly[1][1][1]];
       else factors:=faclib::eval_root(fpoly[1][1][1],p,x);
       end_if;
       fpoly[1][1]:=NIL;
    else factors:=[];
    end_if;
    if p=2 then 
       # using faclib::canzas_2 for case p=2 to simplify computation #
       for i from 1 to nops(fpoly[1]) do
           if degree(op(fpoly[1][i],1))=op(fpoly[1][i],2) then 
              factors:=append(factors,op(fpoly[1][i],1));
           else 
                # generate a global form Rc of random number mod 2           #
                # symmtrically, which is used by faclib::canzas_2 many times #
                faclib::rr(2);
                factors:=append(factors,\
                                op(faclib::canzas_2(op(fpoly[1][i]),x))); 
           end_if;
       end_for;
    else
         # use faclib::canzas for p>2 cases #
         for i from 1 to nops(fpoly[1]) do
             if degree(op(fpoly[1][i],1))=op(fpoly[1][i],2) then
                factors:=append(factors,op(fpoly[1][i],1));
             else 
                  # generate a global form Rc of random number mod p         #
                  # symmtrically, which is used by faclib::canzas many times #
                  faclib::rr(p);
                  factors:=append(factors,\
                              op(faclib::canzas(op(fpoly[1][i]),fpoly[2],p,x)));
             end_if;
         end_for;
    end_if;
    np:=[];
    # according to the pos_g, arrange factors into two parts,  #
    # the first np factors may be the true factors of a(x) in  #
    # Z, the others are impossible to be  factors of a(x) in Z #
    for i from 1 to minfs do
        if not contains(pos_g,degree(factors[i])) then 
           np:=append(np,i); 
        end_if;
    end_for;
    if np<>[] then
       factors:=append(factors,factors[np[i]]$hold(i)=1..nops(np));
       for i from 1 to nops(np) do
           factors[np[i]-i+1]:=NIL;
       end_for;
    end_if;
    # lift factors from Zp to Z, (some of them may need combine) #
    append(fs,faclib::plift(a,lc,factors,minfs,minfs-nops(np),x,p,pos_g));
end_proc:





