# $Date: 1995/06/21 09:18:45 $ $Author: kg $ $Revision: 1.1.2.1 $ #

# kg, 16/12/94 #

#++
faclib::sqrfree_yun -- square-free factorization using yun's algorithm

faclib::sqrfree_yun(p)

p - primitive polynomial over UFD of characteristic 0

faclib::sqrfree_yun(p) returns a list [f1,e1,...,fn,en] where the fi's
are the square-free factors with order ei.

NOTE:
It is assumed that for each indeterminate x of p the following holds:
p is primitive when viewed as polynomial in x. This is true if p was
'pre-factorized' by faclib::pre_factor.
++#

faclib::sqrfree_yun:= proc(p)
    local X, T, x, i, l, q, g, ind;
begin
    X:= op(p,2);
    T:= op(p,3);
    
    # search for indet with minimal degree #
    if nops(X) = 1 then
	x:= null();
    	ind:= null()
    else
        x:= map(X, fun(degree(p, args(1))));
        ind:= contains(x, min(op(x)));
	x:= X[ind];
	ind:= [ind]
    end_if;

    # Yun's factorization #
    i:= 1;    
    l:= [];
    
    q:= Dpoly(ind, p);
    g:= gcd(p, q);
    if degree(g, x) <> 0 then
    	p:= divide(p, g, Exact);
    	q:= divide(q, g, Exact) - Dpoly(ind, p);
    	while not iszero(q) do
    	    g:= gcd(p, q);
    	    if degree(g, x) <> 0 then l:= append(l, g, i) end_if;
    	    i:= i+1;
    	    p:= divide(p, g, Exact);
    	    q:= divide(q, g, Exact) - Dpoly(ind, p);
    	end_while
    end_if;
    
    append(l, p, i)
end_proc:

# end of file #
