# $Date: 1994/09/27 09:59:29 $ $ Author: yuan $ #

#--
faclib::reform -- check the input factor's list [u, f1,e1,..,fn,en], if there
                  are factors with the same degree(ei=ej), then multiply 
                  them(fi*fj), output is also given in form [u, f1,e1,..,fn,en].

faclib::reform(fn,pq)
fn - the list of factors like [u,f1,e1,..,fn,en]
pq - the form of the original input, if it's an expression, then pq=1; if it's a
     polynomial over Z then pq=Expr; if it's a polynomial over Zp, then
     pq=IntMod(p)
--#
  
faclib::reform:=proc(fn,pq)
local f, i, j, n, n2;
begin
    n2:=(nops(fn)-1)/2;
    if pq<>1 then 
       fn:=subsop(fn,(2*i)=expr(op(fn,2*i))$hold(i)=1..n2);
    end_if;
    n:={op(fn,2*i+1)$hold(i)=1..n2};
    (f[op(n,i)]:=1)$hold(i)=1..nops(n);
    for i from 1 to n2 do
        j:=op(fn,2*i+1);
        f[j]:=f[j]*op(fn,2*i);
    end_for;
    if pq=1 then 
       return([op(fn,1),(expand(f[op(n,i)]),op(n,i))$hold(i)=1..nops(n)]);
    else return([op(fn,1),(poly(f[op(n,i)],pq),op(n,i))$hold(i)=1..nops(n)]);
    end_if;
end_proc:
        
