# $Date: 1994/09/27 09:59:13 $ $ Author: yuan $ #

#--
faclib::plift -- lift the factors of univariate polynomial in Zp to Z, the
                 basic idea of the algorithm can be found on page 100-101,
                 Computer algebra symbolic and algebraic computation, edited by
                 Buchberger, G. E. Collins and R. Loos, Springer-Verlag, Wien,
                 1982.  Output is the factors in polynomial form.

faclib::plift(a,lc,f,nf,np,x,p,pos_g)
a - a primitive square free univariate polynomial in Z
lc - lcoeff(a)
f - a list of polynomial in Zp, they are the factors of a in Zp
nf - the number of polynomials in f
np - a nonnegative integer number, the first np polynomials of f may be the true
     factors of a in Z
x - the indeterminate
p - the prime number
pos_g - a set of positive integer number, they are the possible degrees that a's
        factors in Z may have
--#

faclib::plift:=proc(a,lc,f,nf,np,x,p,pos_g)
local bf, d, d1, fc, ff, fl, fo, ft, i, j, la, qua, m2, pj, help_a, po,
      q, q1, s, t, v, vo, w, z;
begin 
    f[1]:=multcoeffs(f[1],lc mod p);
    help_a:=a;
    la:=lc;     
    if (bf:=faclib::bound(a))>p then 
       d1:=degree(f[1]); 
       w[nf]:=f[nf];
       for i from nf-1 downto 2 do 
           w[i]:=f[i]*w[i+1]; 
       end_for;
       q:=poly(1,[x],IntMod(p));
       v:=[];
       # compute v, such that b[1]*v[1]+..+b[nf]*v[nf]=1 mod p, with #
       # degree(v[j])<degree(f[j]), where in terms of the given list #
       # of polynomials f[1],..,f[nf], the polynomials b[i](i=1..nf) #
       # are defined by b[i]=f[1]*..*f[i-1]*f[i+1]*..*f[nu]          #
       for i from 1 to nf-1 do 
           q1:=faclib::mod_gcd_ex(f[i],w[i+1]);
           v:=append(v,divide(q1[2]*q,f[i],Rem));
           q:=divide(q1[1]*q,w[i+1],Rem);
       end_for;
       v:=append(v,q);
       qua:=TRUE;
       pj:=_power(p,2); 
    end_if;
    help_a:=a;
    po:=p;
    fl:=[1$hold(i)=1..np];
    while po<=bf do 
          fo:=map(f,poly,IntMod(pj));
          if not iszero((d:=poly((poly((lc-lcoeff(fo[1]))*_power(x,d1),[x],\
             IntMod(pj))+fo[1])*_mult(fo[i]$hold(i)=2..nf)-poly(a,IntMod(pj)),\
             Expr))) then
             d:=poly(multcoeffs(d,1/po),IntMod(po));
             for i from 1 to nf do             
                 f[i]:=fo[i]-poly(multcoeffs(poly(divide(v[i]*d,f[i],Rem)\
                                                  ,Expr),po),IntMod(pj));
             end_for;
          else f:=map(f,poly,IntMod(pj));
          end_if;    
          f[1]:=poly((lc-lcoeff(f[1]))*_power(x,d1),[x],IntMod(pj))+f[1];
          j:=0;
          m2:=sqrt(float(pj/2));
          # during lifting, factors are tested if they #
          # are already the true factors of a in Z     #
          for i from 1 to np do
              if fl[i]=1 then 
                 if i=1 then 
                    ff:=poly(f[1],Expr);
                 else ff:=poly(multcoeffs(f[i],la),Expr);
                 end_if;
                 t:=faclib::true_fs(help_a,la,\
                            multcoeffs(ff,sign(lcoeff(ff))/icontent(ff)),pj,m2);
                 if t<>[] then 
                    j:=j+1; 
                    fl[i]:=t[1]; 
                    help_a:=t[2];                  
                    la:=lcoeff(help_a);
                 end_if;
              end_if;
          end_for;
          # if there are true factors, then the bound can be reduced #
          if j>0 then 
             case nf-j 
             of 0 do return(op(fl)); 
             of 1 do if nf=np then 
                        for i from 1 to nops(fl) do 
                            if fl[i]=1 then 
                               fl[i]:=help_a;
                               return(op(fl)); 
                            end_if;                     
                        end_for;
                     else return(op(fl),help_a);
                     end_if;                     
             end_case;
             bf:=faclib::bound(help_a);
          end_if;
          if bf<pj then 
             break; 
          else w[nf]:=f[nf];
               for i from nf-1 downto 2 do 
                   w[i]:=f[i]*w[i+1]; 
               end_for;
               if qua then
                  # if pj*p^3>bf use linear lifting, #
                  # otherwise quadratic lifting      #
                  if bf<pj*p^3 then 
                     qua:=FALSE;
                     v:=map(v,poly,IntMod(pj));
                     po:=pj;
                     pj:=pj*p;
                  else 
                       # for quadratic lifting, v need to be modified #
                       z[1]:=f[1];
                       for i from 2 to nf-1 do 
                           z[i]:=f[i]*z[i-1]; 
                       end_for;
                       vo:=map(v,poly,IntMod(pj));
                       s:=poly(multcoeffs(poly(vo[1]*w[2]+_plus(z[i-1]*vo[i]*\
                               w[i+1]$hold(i)=2..nf-1)+z[nf-1]*vo[nf],Expr)\
                               -poly(1,[x]),1/po),IntMod(po));
                       for i from 1 to nf do
                           v[i]:=vo[i]-poly(multcoeffs(poly(divide(v[i]*s,\
                               poly(f[i],IntMod(po)),Rem),Expr),po),IntMod(pj));
                       end_for;
                       po:=pj;
                       pj:=pj*pj;
                  end_if;
               else v:=map(v,poly,IntMod(pj));
                    po:=pj;
                    pj:=pj*p;
               end_if;
          end_if;
    end_while;
    ft:=[]; 
    fc:=[];
    for i from 1 to np do 
        if fl[i]=1 then 
           fc:=append(fc,f[i]); 
        else ft:=append(ft,fl[i]); 
        end_if; 
    end_for;
    fc:=append(fc,f[i+np]$hold(i)=1..nf-np);
    if fc=[] then 
       return(op(ft));
    else 
         # some of factors need to combine #
         op(ft),op(faclib::combine(help_a,la,\
         subsop(fc,1=multcoeffs(fc[1],1/lcoeff(fc[1]))),pj,pos_g));
    end_if;
end_proc:


