# $Date: 1994/11/16 11:12:12 $ $ Author: yuan $ #

#--
faclib::mhensel -- lift the factors of polynomial from Z[x1] to Z[x1..xn], the
                   algorithm comes from Keith O. Geddes, Stephen R. Czapor and
                   George Labahn, Algorithms for computer algebra, page 271-272,
                   kluwer Academic Publishers, 1992.  Output is given in a list 
                   of factors in polynomial form.

faclib::mhensel(nu,p,u,lfs,bn,pl,x0)
nu - a positive integer number, it is the number of polynomials in u
p - a primitive square free multivariate polynomial in Z[x1..xn]
u - a list of nu univariate polynomials in Zpl[x1], which are pairwise
    relatively prime in Zpl[x1], such that u[1]*..*u[nu]=p mod <I, pl> 
lfs - a list of nu correct multivariate leading coefficients corresponding to
      the univariate factors 
bn - a list of equations [x2=a2,..,xn=an], representing an evaluation
     homomorphism used, mathematically viewed as the idea I=<x2-a2,..,xn-an>
pl - a prime number
x0 - the main variable
--#

faclib::mhensel:=proc(nu,p,u,lfs,bn,pl,x0)
local e, fs, i, j, k, m, mono, maxdeg, nfs, nv, pv, px, t, u1, var;
begin
    # initialization for the multivariate iteration #
    nv:=nops(bn); 
    pv[nv+1]:=p;
    for j from nv downto 1 do 
        pv[j]:=mapcoeffs(evalp(pv[j+1],bn[j]),mods,pl);
    end_for;
    maxdeg:=degree(p,op(p,[2,nops(op(p,2))]));
    # variable-by-variable Hensel iteration # 
    for j from 1 to nv do 
        nfs:=nu; 
        var:=[op(p,[2,i])$hold(i)=1..j+1]; 
        u1:=u;
        u:=map(u,poly,var); 
        mono:=poly(1,var); 
        if lfs<>[] then
           for m from 1 to nu do 
               if type(lfs[m])<>DOM_INT then
                  u[m]:=u[m]-poly(lmonomial(poly(u[m],[x0])),var)+\
                        mapcoeffs(poly(subs(lfs[m],[bn[i]$hold(i)=(j+1)..nv])\
                                  *_power(x0,degree(u[m],x0)),var),mods,pl);
               end_if;
           end_for;
        end_if;
        e:=pv[j+1]-_mult(u[i]$hold(i)=1..nu);
        for m from 1 to degree(pv[j+1],op(bn[j],1)) do
            if iszero(e) then 
               break;
            else 
                 # check if any polynomial in u is already true in Z[x1..xj], #
                 # if true then replace that one in u equals 1, it need not   #
                 # to be motified in this j iteration further                 #
                 for k from 1 to nu do 
                     if expr(u[k])<>1 then 
                        if lcoeff(pv[j+1]) mod lcoeff(u[k])=0 then
                           if tcoeff(pv[j+1]) mod tcoeff(u[k])=0 then
                              if (t:=divide(pv[j+1],u[k],Exact))<>FAIL then 
                                 pv[j+1]:=t; 
                                 fs[k]:=u[k];
                                 u1:=subsop(u1,[k,1]=1);
                                 u:=subsop(u,[k,1]=1); 
                                 nfs:=nfs-1; 
                                 if nfs=1 then 
                                    break; 
                                 end_if;
                              end_if;
                           end_if;
                        end_if;
                     end_if; 
                 end_for;
                 if nfs=1 then 
                    for i from 1 to nu do 
                        if expr(u[i])<>1 then
                           u:=subsop(u,i=mapcoeffs(pv[j+1],mods,pl));
                           break;
                        end_if; 
                    end_for;
                    break;
                 elif nfs<nu then
                      e:=mapcoeffs(pv[j+1]-_mult(u[i]$hold(i)=1..nu),mods,pl);
                      if iszero(e) then 
                         break; 
                      end_if;
                 end_if;             
            end_if; 
            mono:=mono*poly(op(bn[j],1)-op(bn[j],2),var);
            px:=contains(op(e,2),op(bn[j],1));
            t:=Dpoly([px$m],e); # diff(e,op(bn[j],1)$m); #
            t:=multcoeffs(evalp(t,bn[j]),1/fact(m));
            if not iszero(t) then
               t:=faclib::diophant(u1,nu,t,[bn[i]$hold(i)=1..(j-1)],maxdeg,pl);
               t:=map(map(t,poly,var),_mult,mono);
               u:=[mapcoeffs(u[i]+t[i],mods,pl)$hold(i)=1..nu];
               e:=mapcoeffs(pv[j+1]-_mult(u[i]$hold(i)=1..nu),mods,pl);
            end_if;
        end_for;
        # restore the already true polynomials #
        # to u for the next variable lifting   #
        if nfs<nu then
           for m from 1 to nu do 
               if expr(u[m])=1 then 
                  u:=subsop(u,m=fs[m]);
               end_if;
           end_for;
        end_if;
    end_for;
    # check termination status #
    if _mult(u[i]$hold(i)=1..nu)=p then 
       u:=map(u,faclib::primpart); 
       for i from 1 to nu do
           if lcoeff(u[i])<0 then 
              u:=subsop(u,i=multcoeffs(op(u,i),-1));
           end_if;
       end_for;
       u;
    else FAIL; 
    end_if;
end_proc:
                 
                          
