# $Date: 1994/11/08 17:30:01 $ $ Author: yuan $ #

#--
faclib::diophant -- solve the multivariate polynomial diophant equation in
                    Zpl[x1..xn]: s[1]*b[1]+..+s[nu]*b[nu]=cc mod <I,pl>, where
                    in terms of the given list of polynomials u[1],..,u[nu], the
                    polynomials b[i](i=1..nu) are defined by
                    b[i]=u[1]*..*u[i-1]*u[i+1]*..*u[nu].  Output is a list of
                    polynomials.

faclib::diophant(u,nu,cc,bn,md,pl)
u - a list of nu polynomials in Z[x1..xn]
nu - a positive integer number, its the number of polynomials in u 
cc - a polynomial in Z[x1..xn]
bn - a list of equations [x2=a2,..,xn=an], representing an evaluation
     homomorphism, mathematically viewed as the idea I=<x2-a2,..,xn-an>
md - a positive integer number, specifying the maximum total degree with respect
     to x2..xn of the desired result
pl - a prime number

faclib::meealift -- compute c such that c[1]*b[1]+..+c[nu]*b[nu]=1 mod pl, with
                    degree(c[j])<degree(u[j]), where in terms of the given list
                    of polynomials u[1],..,u[nu], the polynomials b[i](i=1..nu)
                    are defined by b[i]=u[1]*..*u[i-1]*u[i+1]*..*u[nu]

faclib::meealift(u,nu)
u - a list of nu polynomials in Z[x1,a2,..,an]
nu - a positive integer number, its the number of polynomials in u

faclib::diophant2 -- solve the univariate polynomial diophant equation in 
                     Zpl[x1]: s[1]*u1+s[2]*u2=cc mod pl 

faclib::diophant2(u1,u2,cc)
u1, u2, cc - a square free univariate polynomial in Zpl 

the algorithms of faclib::diophant, faclib::meealift and faclib::diophant2 can
be found on page 268-271 of Algorithms for computer algebra, written by Keith O.
Geddes, Stephen R. Czapor and George Labahn, published by Kluwer Academic Publishers in 1992.

faclib::meealift may be called by faclib::diophant repeatly with the same input,
so set "option remember"

faclib::diophant2 may be called by faclib::diophant and faclib::meealift
repeatly with the same input, so also set "option remember"
--#

faclib::diophant:=proc(u,nu,cc,bn,md,pl)
local a, bnew, cnew, cn, e, f, i, j, mono, n, nv, px, s, unew, x, un;
begin
    nv:=nops(bn);
    if nv>0 then
       # multivariate case #
       x:=op(bn,[nv,1]); 
       a:=op(bn,[nv,2]);
       f:=[(_mult(u[j]$hold(j)=1..(i-1))*\
            _mult(u[j]$hold(j)=(i+1)..nu))$hold(i)=1..nu];
       unew:=map(u,evalp,bn[nv]); 
       cnew:=evalp(cc,bn[nv]);
       bnew:=[bn[i]$hold(i)=1..(nv-1)];
       s:=map(faclib::diophant(unew,nu,cnew,bnew,md,pl),poly,op(cc,2));
       cn:=_plus(s[i]*f[i]$hold(i)=1..nu); 
       e:=mapcoeffs(cc-cn,mods,pl); 
       mono:=poly(1,op(cc,2));   
       for j from 1 to md do
           if iszero(e) then 
              break;
           else mono:=mono*poly(x-a,op(cc,2));
                px:=contains(op(e,2),x);
                cn:=Dpoly([px$j],e); # diff(e,x$j) #
                cn:=multcoeffs(evalp(cn,bn[nv]),1/fact(j));
                if not iszero(cn) then
                   cn:=map(map(faclib::diophant(unew,nu,cn,bnew,md,pl),\
                               poly,op(cc,2)),_mult,mono);
                   s:=[(s[i]+cn[i])$hold(i)=1..nu]; 
                   cn:=_plus(cn[i]*f[i]$hold(i)=1..nu);
                   e:=mapcoeffs(e-cn,mods,pl);
                end_if;
           end_if;
       end_for;
       map(s, mapcoeffs, mods, pl);
    elif nu<3 then
         # special univariate case, only two factors #
         map(faclib::diophant2(op(map(u,poly,IntMod(pl))),poly(cc,IntMod(pl))),\
             poly,Expr);
    else 
         # univariate case #
         un:=map(u,poly,IntMod(pl));
         cn:=faclib::meealift(un,nu);
         map([divide(poly(cc,IntMod(pl))*cn[i],un[i],Rem)$hold(i)=1..nu],\
             poly,Expr);
    end_if;
end_proc:


faclib::meealift:=proc(u,nu)
local cn, f, j, q;
option remember;
begin
    q[nu-1]:=u[nu];
    for j from nu-2 downto 1 do 
        q[j]:=u[j+1]*q[j+1]; 
    end_for;
    f:=[subsop(u[1],1=1)]; 
    cn:=[];
    for j from 1 to nu-1 do
        f:=faclib::diophant2(q[j],u[j],f[1]); 
        cn:=append(cn,f[2]);
    end_for;
    append(cn,f[1]); 
end_proc:
 


faclib::diophant2:=proc(u1,u2,cc)
local cn,f;
option remember;
begin
    f:=faclib::mod_gcd_ex(u2,u1);                     
    cn:=divide(cc*f[1],u1);
    [cn[2],cc*f[2]+cn[1]*u2];
end_proc:


 
         
                
             
