# $Date: 1994/09/27 09:58:13 $ $ Author: yuan $ #

#--
faclib::combine -- get the true factors in Z through the combination of the
                   factors in Zp, the algorithm of generation of combinations 
                   (k subsets) in lexicographic order can be found on page 181
                   of Edward M. Reingold, Jurg Nievergelt, Narsigh Deo,
                   Combinatorial algorithm, theory and pratice, Prentice-Hall,
                   Inc., 1977, output is a list of factors in polynomial form. 

faclib::combine(a,lc,f,p,pos_grad) 
a - a square free polynomial in Z
lc - lcoeff(a)
f - a list of polynomials in Z, they are the factors of a in Zp
p - a positive integer number
pos_grad - a set of positive integer number, they are the possible degrees of
           the factors of a in Z
--#

faclib::combine:=proc(a,lc,f,p,pos_g)
local b, c, fs, i, j, k, l, lt, n, n0, pf, pos;
begin
    fs:=[];
    n:=nops(f);
    lt:=lc*tcoeff(a);
    k:=1;
    while 2*k<=n do 
          c:=array(0..k,(0)=-1);
          for i from 1 to k do 
              c[i]:=i;
          end_for;
          j:=1;
          while j>0 do 
                pos:=FALSE;
                # to see if the combination of these factors is a true factor, #
                # instead of doing polynomials division directly, at first     #
                # check if it has the possible degree, then check if its tcoeff#
                # and lcoeff divide that of polynomial to be factorized        #
                if contains(pos_g,_plus(degree(f[c[l]])$hold(l)=1..k)) then
                   if lt mod mods(lc*_mult(coeff(f[c[l]],0)$hold(l)=1..k),p)=0\
                      then 
                      pf:=faclib::primpart(poly(multcoeffs(\
                                  _mult(f[c[l]]$hold(l)=1..k),lc),Expr));
                      if lc mod lcoeff(pf)=0 then 
                         if (b:=divide(a,pf,Exact))<>FAIL then 
                            pos:=TRUE;  
                         end_if;                     
                      end_if;
                   end_if;
                end_if;                
                if pos then
                   fs:=append(fs,pf); 
                   if (n:=n-k)<2*k then 
                      return(append(fs,b));
                   end_if;
                   a:=b;
                   lc:=lcoeff(a);
                   lt:=lc*tcoeff(a);
                   # rearrange the other factors and c, #
                   # then combine them for the next j   #
                   for i from 1 to k do 
                       f[c[i]-i+1]:=NIL; 
                   end_for;
                   if (n0:=c[1]-1)<n-k then 
                      for i from 1 to k do
                          c[i]:=n0+i;
                      end_for;
                   else j:=0;
                   end_if;
                else j:=k;
                     while c[j]=n-k+j do 
                           j:=j-1; 
                     end_while;
                     if 2*k=n and j=1 then 
                        break;
                     else c[j]:=c[j]+1;
                     end_if;
                     for i from j+1 to k do 
                         c[i]:=c[i-1]+1;
                     end_for;
                end_if;
          end_while;
          k:=k+1;
    end_while;
    append(fs,a);
end_proc:
