# $Date: 1994/09/27 09:57:55 $ $ Author: yuan $ #

#--
faclib::bound -- get the upper bound of factors of input univariate polynomial,
                 see Maurice Mignotte, Mathematics for computer algebra, page 
                 295, Springer-Verlag New York, Inc.,1992, output is a positive
                 integer number.
  
faclib::bound(a):
a - a square free univariate polynomial
--#

faclib::bound:=proc(a)
local d;
begin
    d:=degree(a);
    _power(2,1+(d div 2))*ceil(float(sqrt(_power(2,d mod 2)*(1+d))))*norm(a)*\
    abs(lcoeff(a));
end_proc:
