# $Date: 1995/07/17 09:36:45 $ $Author: kg $ $Revision: 1.18.2.2 $ #
#++
Integer -- domain of integer numbers

An integer is represented by a system-integer (DOM_INT). There is
no DOM_EXT to represent an integer. This fact is expressed by the axiom
'systemRep'.

Methods:-
testtype(x,D)      - returns TRUE if x is of type DOM_INT
invert(x)          - returns x if x is 1 or -1 and FAIL otherwise
divex(x,y)         - returns x/y if y divides x and FAIL otherwise
divides(x,y)       - returns TRUE iff x divides y
euclideanDegree(x) - returns the euclidean degree of x, ie., abs(x)
unitNormal(x)      - returns the unit normal part of x, ie., abs(x)
unitNormalRep(x)   - returns the unit normal rep. of x, ie. the
		     list [abs(x), sign(x), -sign(x)]
gcd(x1,x2,...)     - returns the gcd of the xi
gcdex(x,y)         - returns g,v,w such that g = gcd(x,y) = x*v + y*w
lcm(x1,x2,...)     - returns the lcm of the xi
quo(x,y)           - returns the euclidean quotient of x and y, ie., x div y
rem(x,y)           - returns the euclidean reminder of x and y, ie., modp(x,y)
convert(x)         - returns the value of x converted to Integer
min(x,...)	   - returns the minimal argument
max(x,...)	   - returns the maximal argument
Factor(x)	   - returns the factorisation of x
isPrime(x)	   - returns TRUE iff x is prime
random()	   - returns a random number in the range -999..999
random(n)	   - returns a random number between 0 and n-1
random(m..n)	   - returns a random number between m and n
++#

Integer:= DomainConstructor(

    Integer,
    [ ],
    [ ],
    NIL,
    Numerical,
    [ EuclideanDomain, FactorialDomain, DifferentialRing, OrderedSet ],
    [ canonicalRep, systemRep, canonicalOrder,
      canonicalUnitNormal, closedUnitNormals ],

    "testtype" = fun((
	if domtype(args(1)) = DOM_INT then TRUE else FAIL end_if
    )),

    "invert" = proc()
	local p;
    begin
	p:= proc() begin FAIL end_proc;
	p(1):= 1;
	p(-1):= -1;
	p
    end_proc(),

    "divex" = fun((
	if modp(args(1), args(2)) = 0 then (args(1) div args(2)) else FAIL end_if
    )),

    "divides" = fun(
	bool(modp(args(2), args(1)) = 0)
    ),

    "isUnit" = proc()
	local p;
    begin
	p:= proc() begin FALSE end_proc;
	p(1):= TRUE;
	p(-1):= TRUE;
	p
    end_proc(),

    "associates" = fun(
	bool(abs(args(1)) = abs(args(2)))
    ),

    "euclideanDegree" = abs,

    "unitNormal" = abs,

    "unitNormalRep" = fun((
        if args(1) = 0 then
            [ 0, 1, 1 ]
        else
	    [ abs(args(1)), sign(args(1)), sign(args(1)) ]
        end_if
    )),

    "gcd" = igcd,

    "gcdex" = igcdex,

    "lcm" = ilcm,

    "quo" = _div,

    "rem" = modp,

    "min" = min,

    "max" = max,

    "Factor" = ifactor,

    "isPrime" = isprime,

    "divide" = fun(
        op([ args(1) div args(2), modp(args(1), args(2)) ])
    ),

    "convert" = fun((
       if domtype(args(1)) = DOM_INT then args(1) else FAIL end_if
    )),

    "convert_to" = fun((
	if domtype(args(1)) <> DOM_INT then FAIL else
	    case args(2)
	    of Integer do
	    of Rational do
	    of DOM_INT do
	    of Numerical do args(1); break;
	    of DOM_FLOAT do
	    of Float do float(args(1)); break;
	    otherwise FAIL;
	    end_case
	end_if
    )),
    
    "randomGen" = table((-999..999)=random(-999..999)),
    
    "random" = fun((
        if args(0) = 0 then
            this::randomGen[-999..999]()
        else
            if not contains(this::randomGen, args(1)) then
                this::randomGen[args(1)]:= random(args(1))
            end_if;
            this::randomGen[args(1)]()
        end_if
    ))

)():

