# $Date: 1995/06/28 10:01:53 $ $Author: kg $ $Revision: 1.17.2.1 $ #
#++
Float -- the domain of floating point numbers

A floating point number is represented by an expression of type DOM_FLOAT.

This domain has category Field, which is very optimistic. Of course the
implementation is not a field because for example
bool(1.0 = float(3) / float(3))
returns FALSE. Only because of pragmatism floats are assumed do be a field.

Methods:-
_less(x,y)    - returns TRUE iff x < y (in boolean contex only)
_leequal(x,y) - returns TRUE iff x <= y (in boolean contex only)
convert(x)    - returns the value of x converted to Float
++#

Float:= DomainConstructor(

    Float,
    [ ],
    [ ],
    NIL,
    Numerical,
    [ Field, DifferentialRing, OrderedSet ],
    [ canonicalRep, systemRep, canonicalOrder ],

    "zero" = 0.0,

    "one" = 1.0,

    "testtype" = proc(e,D)
    begin
	if contains({DOM_INT,DOM_RAT,DOM_FLOAT}, domtype(e))
	then TRUE else FAIL end_if
    end_proc,

    "convert" = fun((
	float(args(1));
	if domtype(%) = DOM_FLOAT then % else FAIL end_if
    )),

    "convert_to" = proc(x,T) begin
	if not contains({DOM_INT,DOM_RAT,DOM_FLOAT}, domtype(x)) then FAIL else
	    case T
	    of Float do
	    of DOM_FLOAT do float(x); break;
	    of Numerical do x; break;
	    otherwise FAIL;
	    end_case
	end_if
    end_proc,
    
    "min" = min,

    "max" = max,
    
    "random" = fun(tan(float(PI) * (random()/(10.0^12) - 0.5)))

)():

