# $Date: 1995/07/03 09:52:08 $ $Author: kg $ $Revision: 1.10.2.1 $ #

#++
AlgebraicExtension -- domain constructor for simple algebraic extension

AlgebraicExtension(F, p [,a])

F - field
p - irreducible polynomial or expression defining adjoined element
a - name of the adjoined element (identifier)

AlgebraicExtension(F,p,a) creates a simple algebraic extension F(a) where a
are the roots of an irreducible polynomial defined by p. p must either be an
equation, a polynomial expression or a DOM_POLY.

- If p is a polynomial expression or a DOM_POLY, it is converted into a
  univariate polynomial over F in the variable a. If a is not given then p
  must have exactly one unknown which then takes the role of a.

- If p is an equation x=y, it is changed into the expression x-y. x-y is then
  used as defining polynomial, such that the same rules as above apply.

It is not tested wether p is irreducible or not!

Methods:-
conjNorm(x) - returns the norm of x, ie. the product of all conjugates of x
++#

AlgebraicExtension := DomainConstructor(
    AlgebraicExtension,
    [ F , PExpr, Alias ],
    [ P ],
    (case args(0)
     of 2 do 
         Alias:= null(); 
         break;
     of 3 do
         if domtype(Alias) <> DOM_IDENT then
	     error("illegal variable type")
         end_if;
         Alias:= [ Alias ];
         break;
     otherwise error("wrong no of args")
     end_case;
     if not F::hasProp(Field) then
        error("no field given")
     end_if;
     if not F::hasProp(normalRep) then
        error("field has no normal representation")
     end_if;
     if type(PExpr) = "_equal" then
         PExpr:= op(PExpr,1) - op(PExpr,2)
     end_if;
     if F = Rational then
	P:= poly(PExpr, Alias);
	if not testtype(P, Type::PolyOf(Type::Rational,1)) then
	    error("not a univariate polynomial")
	end_if;
     elif F::constructor = IntegerMod then
	P:= poly(PExpr, Alias, hold(IntMod)(F::constructor_args[1]));
	if P = FAIL then
	    error("not a polynomial")
	end_if;
	if nops(op(P,2)) <> 1 then
	    error("multivariate polynomial")
	end_if;
     else
	P:= poly(PExpr, Alias, F);
	if P = FAIL then
	    error("not a polynomial")
	end_if;
        if nops(op(P,2)) <> 1 then
	    error("multivariate polynomial")
        end_if;
     end_if;
     if degree(P) = 0 then
     	error("constant polynomial")
     end_if;
     P:= multcoeffs(P, 1/lcoeff(P));
     PExpr:= (expr(P) = 0);
     Alias:= op(P,[2,1]);
    ),
    BaseDomain,
    [ Field, Algebra(F) ],
    [ (if F::hasProp(canonicalRep) then canonicalRep else normalRep end_if) ],

    "characteristic" = F::characteristic,
    
    "zero" = new(this, P-P),

    "one" = new(this, P^0),

    "_plus" = fun((
    	if map({args()}, domtype) <> {this} then FAIL
    	else new(this, _plus(extop(args(i),1) $ hold(i)=1..args(0)))
    	end_if
    )),

    "negate" = fun(new(this, -extop(args(1),1))),

    "minus" = fun(new(this, extop(args(1),1)-extop(args(2),1))),

    "iszero" = fun(iszero(extop(args(1), 1))),

    "_mult" = (if F::hasProp(systemRep) then
        fun((if args(0) = 2 then
    	    if domtype(args(2)) <> this then
    	    	if domtype(args(2)) = DOM_INT then
    	    	    this::intmult(args())
    	    	elif testtype(args(2), F) then
    	    	    new(this, multcoeffs(extop(args(1),1), F::convert(args(2))))
    	    	else
    	    	    (domtype(args(2)))::_mult(args())
    	    	end_if
    	    elif domtype(args(1)) <> this then
    	    	if domtype(args(1)) = DOM_INT then
    	    	    this::intmult(args(2), args(1))
    	    	elif testtype(args(1), F) then
    	    	    new(this, multcoeffs(extop(args(2),1), F::convert(args(1))))
    	    	else
    	    	    FAIL
    	    	end_if
    	    else
    	        new(this, divide(extop(args(1),1) * extop(args(2),1), P, Rem))
    	    end_if
    	elif args(0) = 1 then
    	    args(1)
    	else
    	    _mult(args(i) $ hold(i)=1..(args(0) div 2));
    	    _mult(args(i) $ hold(i)=((args(0) div 2) + 1)..args(0));
    	    _mult(%1, %2)
    	end_if))
    else
        fun((if args(0) = 2 then
    	    if domtype(args(2)) <> this then
    	    	case domtype(args(2))
    	    	of DOM_INT do this::intmult(args()); break;
    	    	of F do new(this, multcoeffs(extop(args(1),1), args(2))); break;
    	    	otherwise (domtype(args(2)))::_mult(args());
    	    	end_case
    	    elif domtype(args(1)) <> this then
    	    	case domtype(args(1))
    	    	of DOM_INT do this::intmult(args(2), args(1)); break;
    	    	of F do new(this, multcoeffs(extop(args(2),1), args(1))); break;
    	    	otherwise FAIL;
    	    	end_case
    	    else
    	        new(this, divide(extop(args(1),1) * extop(args(2),1), P, Rem))
    	    end_if
    	elif args(0) = 1 then
    	    args(1)
    	else
    	    _mult(args(i) $ hold(i)=1..(args(0) div 2));
    	    _mult(args(i) $ hold(i)=((args(0) div 2) + 1)..args(0));
    	    _mult(%1, %2)
    	end_if))
    end_if),
    
    "intmult" = fun(new(this, multcoeffs(extop(args(1),1), args(2)))),

    "invert" = proc(c)
	local q,c1,c2,d,d1,d2,r,r1,r2,l;
    begin
	c:= extop(c,1);
	if degree(c) = 0 then return(new(this, mapcoeffs(c, 1/id))) end_if;
	l:= 1/lcoeff(c);
	c:= multcoeffs(c, l);
	c1:= extop(this::one,1);
	d1:= extop(this::zero,1);
	c2:= d1;
	d2:= c1;
	d:= P;
	while not iszero(d) do
	    q:= divide(c,d); r:= op(q,2); q:= op(q,1);
            r1:= c1-q*d1; r2:= c2-q*d2;
            c:= d; c1:= d1; c2:= d2;
            d:= r; d1:= r1; d2:= r2;
	end_while;
        new(this, multcoeffs(c1, l / lcoeff(c)))
    end_proc,

    "conjNorm" = (if F::constructor = IntegerMod then
        fun(F::convert(resultant(extop(args(1),1), P, hold(Alias))))
    else
        fun(resultant(extop(args(1),1), P, hold(Alias)))
    end_if),
    
    # convert -- convert expression into algebraic number
   
      The expression must be a polynomial of the same type as the polynomial P
      defining the adjoinded element. It is interpreted as a polynomial in the
      adjoined element. #
     
    "convert" = (if F::constructor = IntegerMod then
        proc(x) begin
   	    if domtype(x) = this then
                return(x)
            end_if;
   	    x:= poly(x, op(P, 2..3));
   	    if x = FAIL then return(FAIL) end_if;
   	    new(this, divide(x, P, Rem))
        end_proc
    else
        proc(x) begin
   	    if domtype(x) = this then
                return(x)
            end_if;
   	    x:= poly(x, op(P, 2..3));
   	    if not testtype(x, Type::PolyOf(F)) then return(FAIL) end_if;
   	    new(this, divide(x, P, Rem))
        end_proc
    end_if),
   
    "expr" = fun(expr(extop(args(1),1))),
        
    "random" = (if F = Rational then
	fun(new(this,
	    divide(randpoly([hold(Alias)], Expr, Degree=degree(P)), P, Rem)))
    elif F::constructor = IntegerMod then
	fun(new(this, 
	    divide(randpoly([hold(Alias)], op(P,3), Degree=degree(P)), P, Rem)))
    else
	fun(new(this, 
	    divide(randpoly([hold(Alias)], F, Degree=degree(P)), P, Rem)))
    end_if)

):

# end of file #
