# $Date: 1995/04/26 08:13:56 $ $Author: kg $ $Revision: 1.6 $ #

#++
hasProp -- check if a domain has a certain property

hasProp(this, attr)

this - domain
attr - attribute to check for (super-domain, category, axiom or constructor)

hasProp returns TRUE, if the domain has super-domain, category or axiom
'attr' or a constructor of one of these objects. The method normally is not
called directly but rather by the entry 'hasProp' of a domain. (This method
is defined by the domain 'BaseDomain'.)
++#

DomainConstructor::hasProp:= fun((
    if testargs() then
        if args(0) <> 2 then error("wrong no of args") end_if;
        if domtype(args(1)) <> DOM_DOMAIN then
            error("invalid domain")
        end_if;
        if (args(1))::axioms = FAIL or (args(1))::categories = FAIL then
            error("not created by constructor")
        end_if;
    end_if;

    case domtype(args(2))
    of Axiom do
	bool(contains((args(1))::axioms, args(2)));
	break;
    of AxiomConstructor do
	bool(contains(map((args(1))::axioms, extop, 1), args(2)));
	break;
    of Category do
	bool(contains((args(1))::categories, args(2)) <> 0);
	break;
    of CategoryConstructor do
	bool(contains(map((args(1))::categories, extop, 1), args(2)) <> 0);
	break;
    of DOM_DOMAIN do
        if args(1) = args(2) then
            TRUE
        else
            bool(contains((args(1))::super_domains, args(2)) <> 0)
        end_if;
        break;
    of DomainConstructor do
        if (args(1))::constructor = args(2) then
            TRUE
        else
            bool(contains(map((args(1))::super_domains, domattr, "constructor"),
            		  args(2)) <> 0)
        end_if;
        break;
    otherwise error("invalid attribute");
    end_case
)):

# end of file #
