# $Date: 1995/06/28 09:10:47 $ $Author: kg $ $Revision: 1.7.2.1 $ #

#++
new -- create new category constructor

new(name, params, locals, precomp, categories, axioms, entry...)

name        - name of constructor (expression)
params      - list of formal parameters (list of ident's)
locals      - list of local variables (list of ident's)
precomp     - expression to test actual parameters and compute locals
categories  - list of expressions used to compute the super-categories
axioms      - list of expressions used to compute the axioms
entry...    - expressions to define domain entries (equations or names)

The arg's are not evaluated. Later on, when a new domain is to be
constructed, the actual parameters and locals of the category of
the domain and the domain itself are substituted for the formal
parameters, locals resp. the ident 'this' in the expressions given by
'categories'...'entry...'. After the substitution these expressions
are evaluated.

Entries for the domains of the categories at hand are defined by the
arguments 'entry...'. These entries are defined either by an equation
of the form 'name = value' or simply by an entry name (a string).

Giving only a name as entry definition means: This entry has to be defined
somewhere else (normally in the domain constructor or in a sub-category).
If such an 'empty' entry is evaluated a run-time error will occure.
++#

CategoryConstructor::new:= proc(nam, params, locals)
    local t, i;
    option hold;
begin
    if testargs() then
        if args(0) < 6 then error("wrong no of args") end_if;

        # test formal parameters and locals #
	if not testtype(params, Type::ListOfIdents()) then
            error("invalid parameter list")
        end_if;
	if not testtype(locals, Type::ListOfIdents()) then
            error("invalid parameter list")
        end_if;

        # categories and axioms must be given by lists #
        if domtype(args(5)) <> DOM_LIST then
            error("illegal categories list")
        end_if;
        if domtype(args(6)) <> DOM_LIST then
            error("illegal axioms list")
        end_if;

        # test entry definitions #
        if args(0) > 6 then
            if nops(map(map({$7..args(0)}, args), type) minus
                    { "_equal", DOM_STRING }) <> 0 then
                error("wrong entry list")
            end_if;
        end_if;
    end_if;

    # create table with entry definitions #
    t:= table();
    for i from 7 to args(0) do
        if type(args(i)) = "_equal" then
            t[op(args(i),1)]:= op(args(i),2);
        else
            t[args(i)]:= hold(toBeDefined);
        end_if
    end_for;

    # create constructor #
    new(CategoryConstructor, nam, params.locals,
        subsop(proc() begin X; Y end_proc,
            1=op(params), 2=op(locals),
            [4,1]=args(4), [4,2]=params.locals, 6=nam),
        args(5), args(6), t, domain(), nops(params));
end_proc:

# end of file #
