# $Date: 1995/05/19 06:51:31 $ $Author: kg $ $Revision: 1.2 $ #

# kg, 28/04/95 #

#++
add -- add entrys to category constructor

add(CC, entry...)

CC       - category constructor or category
entry... - expressions to define domain entries (equations)

Adds entries to the constructor CC, returns a new constructor.

The entry's are not evaluated. Later on, when a new domain entry is to be
constructed, the actual parameters and locals of the category and the domain
itself are substituted for the formal parameters resp. the ident 'this' in
the expressions given by 'entry...'. After the substitution these
expressions are evaluated.
++#

CategoryConstructor::add:= proc(CC)
    option hold;
    local i, t;
begin
    if args(0) < 2 then error("wrong no of args") end_if;
    CC:= context(CC);
    if testargs() then
        case domtype(CC)
        of CategoryConstructor do
            break;
        of Category do
            CC:= extop(CC, 1);
            break;
        otherwise error("no category constructor");
        end_case;
        # only equation are allowed for the entries #
        if map({args(i) $ hold(i)=2..args(0)}, type) <> { "_equal" } then
            error("wrong entry")
        end_if;
    end_if;

    t:= extop(CC,6);
    for i from 2 to args(0) do
        t[op(args(i),1)]:= op(args(i),2)
    end_for;
    extsubsop(CC, 6=t);
end_proc:

# end of file #
