# $Date: 1995/06/28 09:10:38 $ $Author: kg $ $Revision: 1.7.2.1 $ #

#++
new -- create a new axiom constructor

new(name, params, locals, precomp)

name        - name of constructor (ident)
params      - list of formal parameters (list of ident's)
locals      - list of local variables (list of ident's)
precomp     - expression to test actual parameters and compute locals

The arg's are not evaluated. Later on, when a new axiom is to be
constructed via 'func_call', the actual parameters of the axiom are
substituted for the formal parameters in the expression given by
'test_params'. After the substitution the expression is evaluated.
++#

AxiomConstructor::new:= proc(nam, params, locals)
    option hold;
begin
    if testargs() then
        if args(0) <> 4 then error("wrong no of args") end_if;
        if domtype(nam) <> DOM_IDENT and type(nam)<>"domattr" then
            error("invalid name")
        end_if;
	if not testtype(params, Type::ListOfIdents()) then
            error("invalid parameter list")
        end_if;
	if not testtype(locals, Type::ListOfIdents()) then
            error("invalid parameter list")
        end_if;
    end_if;

    new(AxiomConstructor, nam, params.locals,
        subsop(proc() begin X; Y end_proc,
            1=op(params), 2=op(locals),
            [4,1]=args(4), [4,2]=params.locals, 6=nam),
        domain(), nops(params));
end_proc:

# end of file #
