# $Date: 1995/05/17 08:44:44 $ $Author: kg $ $Revision: 1.8 $ #
#++
UnivariatePolynomialCat -- the category of univariate polynomials

UnivariatePolynomialCat(R)

R - coefficient ring

Methods:
pdivide(p,q) - returns a sequence b,s,r such that b*p = q*s + r,
	       degree(r) < degree(q) and b = lcoeff(q)^k
pquo(p,q)    - returns pdivide(p,q)[2]
prem(p,q)    - returns pdivide(p,q)[3]
++#

UnivariatePolynomialCat:= CategoryConstructor(
    UnivariatePolynomialCat,
    [ R ],
    [ ],
    ( if args(0) <> 1 then error("wrong no of args") end_if;
      if R::hasProp(CommutativeRing) <> TRUE then
	error("no commutative ring")
      end_if ),
    [ ( if R::hasProp(Field) then EuclideanDomain end_if ),
      PolynomialCat(R), DifferentialRing ],
    [ ],

    "pdivide", "pquo", "prem"

):

