# $Date: 1995/05/17 08:44:32 $ $Author: kg $ $Revision: 1.6 $ #
#++
RightModule -- the category of right-R-modules

RightModule(R)

R - a Ring

A RightModule is a AbelianGroup together with a Ring R with an
right multiplikation '*' : (this,R) -> this.

Axioms for ring elements a, b and module elements x, y:
	x * (a * b) = (x * a) * b
	x * (a + b) = x * a + x * b
	(x + y) * a = x * a + y * a

Beware: If a SemiGroup is also a RightModule the multiplication '*'
has 2 signatures: '*' : (this,this) -> this and '*' : (this,R) -> this.
The implementation of the multiplication must handle this. The same
kind of problem is occuring if a domain is a Module over more
than one rng.

Methods:-
_mult(x,r) - returns the right multiplikation x*r of x by the rng element r
++#

RightModule:= CategoryConstructor(
    RightModule,
    [ R ],
    [],
    (if args(0) <> 1 then error("wrong no of args") end_if;
     if not R::hasProp(Ring) then error("no ring") end_if),

    [ AbelianGroup ],
    [],

    "_mult"

):

