# $Date: 1995/05/26 07:58:32 $ $Author: kg $ $Revision: 1.12 $ #
#++
QuotientField -- the category of quotient fields over R

QuotientField(R)

R - integral domain

Methods:
numer(x)     - returns the numerator of x
denom(x)     - returns the denominator of x
retract(x)   - returns numer(x)/denom(x) if this is an element of R and
	       FAIL otherwise
++#

QuotientField:= CategoryConstructor(
    QuotientField,
    [ R ],
    [ ],
    ( if args(0) <> 1 then error("wrong no of args") end_if;
      if R::hasProp(IntegralDomain) <> TRUE then
	error("no integral domain")
      end_if ),
    [ Field, Algebra(R),
      ( if R::hasProp(OrderedSet) then OrderedSet end_if ) ],
    [ ],

    "numer", "denom",

    "characteristic" = R::characteristic,
    
    "iszero" = R::iszero @ this::numer,

    "_less" = ( if R::hasProp(OrderedSet) then
	if not this::hasProp(canonicalOrder) then
	    proc(x,y) begin
		R::_less(R::_mult(this::numer(x), this::denom(y)),
			 R::_mult(this::numer(y), this::denom(x)))
	    end_proc
	end_if
    end_if ),

    "equal" = proc(x,y) begin
	R::equal(R::_mult(this::numer(x), this::denom(y)),
		 R::_mult(this::numer(y), this::denom(x)))
    end_proc,

    "retract" = proc(x) begin
	R::divex(this::numer(x), this::denom(x))
    end_proc

):

# end of file #
