# $Date: 1995/06/28 09:53:54 $ $Author: kg $ $Revision: 1.10.2.1 $
#
#++
OrderedSet -- the category of ordered sets

An OrderedSet is a SetCat with a (complete) order relation '<'.

Use the axiom canonicalOrder to signal that elements of a domain are
canonically ordered as MuPAD expressions.

Methods:
_less(x,y)    - return TRUE iff x < y
_leequal(x,y) - return TRUE iff x < y or x = y
sort(l)	      - returns ascending sorted list if l ist a list of elements
++#

OrderedSet:= CategoryConstructor(
    OrderedSet,
    [],
    [],
    NIL,
    [ SetCat ],
    [],

    "_less" = (if this::hasProp(canonicalOrder) then
	bool @ _less
    else
        toBeDefined
    end_if),

    "_leequal" = (if this::hasProp(canonicalOrder) then
	bool @ _leequal
    else
	proc(a, b) begin
	    this::_less(a, b) or this::equal(a, b)
	end_proc
    end_if),

    "sort" = (if this::hasProp(canonicalOrder) then
	sort
    else
	fun(sort(args(1), this::_less))
    end_if),

    "min" = ( if this::hasProp(canonicalOrder) then
	proc() local m, i; begin
	    if args(0) = 0 then error("no args") end_if;
	    m:= args(1);
	    for i from 2 to args(0) do
		if args(i) < m then m:= args(i) end_if
	    end_for;
	    m
	end_proc
    else
	proc() local m, i; begin
	    if args(0) = 0 then error("no args") end_if;
	    m:= args(1);
	    for i from 2 to args(0) do
		if this::_less(args(i), m) then m:= args(i) end_if
	    end_for;
	    m
	end_proc
    end_if ),

    "max" = ( if this::hasProp(canonicalOrder) then
	proc() local m, i; begin
	    if args(0) = 0 then error("no args") end_if;
	    m:= args(1);
	    for i from 2 to args(0) do
		if m < args(i) then m:= args(i) end_if
	    end_for;
	    m
	end_proc
    else
	proc() local m, i; begin
	    if args(0) = 0 then error("no args") end_if;
	    m:= args(1);
	    for i from 2 to args(0) do
		if this::_less(m, args(i)) then m:= args(i) end_if
	    end_for;
	    m
	end_proc
    end_if )

)():

